#include "mbed.h"
// Declaracion pines de comunicacion
Serial deviceBT(D8, D2); 

// Declaracion de entradas y salidas 
PwmOut motor(A1);
DigitalIn probeta(A5);
AnalogIn analog_value(A0);


int main() {
    
    deviceBT.baud(9600); // Velocidad de comunicacion
    float sensor, meas; // almacena el valor PWM inicializa en 0 y el valor inicial del sensor;
    motor.period_ms(20); // Establece el ancho de pulso maximo para el PWM
    while(probeta==1) {
        //meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        sensor=analog_value.read();
        meas = sensor * 2300; // Change the value to be in the 0 to 1800 range
        motor.pulsewidth_us(meas+500);   // Envia el ancho de pulso al motor
        deviceBT.printf("%f",sensor);  // envia los datos al bluetooth
        wait(1); // tiempo de muestreo, inferior a 1s causa conflicto envia mas de 1 dato

    }
}