
#include "mbed.h"
#include "piezas.h"
#include "avenidas.h"
#include "vehiculos.h"

//#define DEBUG 1
Serial pc(USBTX,USBRX);  
SPI deviceM(PB_5, PB_4, PB_3);  // D4(gris), Ninguno, D3(azul)
DigitalOut ssel (PA_4);         // A2(morado)
Ticker tp;
int printjugador =1;  

// Definiendo Botones
 
AnalogIn vry(A3);                            // Lee el eje x del jostick
AnalogIn vrx(A4);                            // Lee el eje y del jostick
InterruptIn pulsador_abj(D8);                // Lee el boton del jostick
DigitalIn sel(D7);                                                  //hace la seleccion de  juego
PwmOut buzzer(A1);

// Define numeros
uint16_t* global_disp={0};


// Funciones de la pantalla principal

void calle_funtion();
void tetris();
void carros();
void pantalla_pr();
void himno_legria();

// funciones de cruzando la calle

void printstatus_cll();             // Define el prototipo imprime el juego en pantalla
void desplazar_der_cll();          // Define el prototipo que desplaza el jugador a la der 
void desplazar_izq_cll();           // Define el prototipo que desplaza el jugador a la izq
void arriba_cll();                  // Define el prototipo que desplaza el jugador hacia arriba
void pista_cll();                   // Define el prototipo 
void puntaje_cll();                 // Define el prototipo que cuenta el puntaje
void impresion();               // Define el prototipo 
void aumentar_dificultad_cll();     // Define el prototipo  que aumenta la velocidad de los vehiculos
void reiniciar_calle();

// funciones de tetris

void captura_datos_tx();
void read_tx();
void desplazar_tx();
void captura_matriz_tx();
void desplazar_izq_tx();
void desplazar_der_tx();
void aum_velocidad_tx();
void perder_tx();
//funciones carro

void desplazar_izq();
void desplazar_der();
void selec_nivel();
void desplazar();
void selec();
void juego();
void printstatus();
void aum_velocidad_cr();

uint16_t* girar(uint16_t* pieza, int posicion);
// Declaracion de variables  tetris

int8_t posicion= 0, figura= 0, giro= 0;
uint16_t memoria[8]={0};
uint16_t* imprimir;
uint16_t *borde=0;
int8_t corrimiento=0;
// Delcaraion de limites variables  tetris

int8_t liminf=0, limizq=0, limder=0;
// Habilitadores variables  tetris

int enableizq=1;
int enableder=1;
int bajando=1;

// Definicion de Variables de la calle
 
uint16_t* nivel;
uint16_t* jugador;
uint16_t* victorias;
float velocidad = 1.0;
float meas_vx;
float meas_vy; 
uint8_t ubicacion;
uint8_t conteo = 2;


// Definicion de Variables carro

uint16_t* fail;
uint16_t* camino;
uint8_t  enable_der=1;
uint8_t  enable_izq=1;
uint8_t  enable_abj=1;
uint8_t  pos;
uint8_t  posicion_fig=3;
float velocidad_cr = 0.4;

// Funciones pantalla principal



void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};
 
void inicializar_matriz(){
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);    //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0F,0);
        wait (0.5);
    }
  
  }

void debuging(char*s,...){
    
    #if DEBUG
    pc.printf(s);
    #endif
    
    }

  
int main() {                          // ESTA ES LA FUNCION DE SELECCION
                   
   inicializar_matriz();
   pc.baud(38400);
   int selec_p=0;
   
   while(1){
      
      
      meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X
      
      if(meas_vx < 1600)
         selec_p++;
      else if(meas_vx > 1700)
         selec_p--;
         
      if(selec_p > 3)
         selec_p=0;
      else if (selec_p < 0)  
         selec_p=3;
         
      if(selec_p == 0)
         global_disp = SELEC;
      else if (selec_p == 1)  
         global_disp = UNO;
      else if (selec_p == 2)
         global_disp = DOS; 
      else   
         global_disp = TRES;     
         
      wait(0.5);  
    /*  if(meas_vx < 1600)
         global_disp = DOS, selec_p=2;
      else if (meas_vx < 1700)  
         global_disp = SELEC, selec_p=0;
      else
         global_disp = UNO, selec_p=1;
      
    */
      pantalla_pr();               // LLAMA A LA FUNCION QUE DIBUJA EL NUMERO
      
      if (selec_p==1 && sel==1)
          calle_funtion();
      else if (selec_p==2 && sel==1)    
          tetris();
      else if (selec_p==3 && sel==1)
          carros();
      else if (selec_p==3 && sel==1)    
          himno_legria();
          
      }
      
}



void pantalla_pr(){      
          for(int i= 1;i<=8;i++){
          sendSPI(i, global_disp[i-1]);
          }
    }

void calle_funtion(){
    
    while(1){
        
   nivel= AV_1;                    // Asigna el trasado de las calles al juego
   victorias=puntos;               // Asigna los puntos acumulados en la pantalla inicia en 0
   jugador=player;                 // Asigna la forma del jugador
   tp.attach(&printstatus_cll,0.2);    // MIRAR para que sirve
   ubicacion=1;                    // Inicializa la varibale que cuenta la posicion del jugador
   

       
   while(1){
       
   meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X
   meas_vy = vry.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje Y
   
//------ realiza el corriemiento del vector hacia la izq y der respectivamente.

  if (meas_vx < 1600)           // si se cumple esta condicion el jugador se desplaza a la izq
      desplazar_izq_cll(); 
  else if (meas_vx > 1700)      // si se cumple esta condicion el jugador se desplaza a la der
      desplazar_der_cll();
 
//------ mueve a el jugador hacia arriba en el mapa
    
  if(meas_vy < 1550){   
     arriba_cll();                  // hace el llamado a la funcion que mueve al jugador a la parte superior
     ubicacion++;               // cada vez que se ejecuta actualiza la posicion del jugador en el mapa
     pc.printf("\n ubicacion:\n %i",ubicacion);  // imprime la ubicacion del jugador en el puerto serial
     if(ubicacion==7)           // si la posicion del jugador es igual a 7 ejecuta la funcion puntaje_cll();
        puntaje_cll();         
     }
     
// ----- El siguiente ciclo realiza el desplazamiento de los vehiculos
  pista_cll(); 
  
  wait(velocidad); // Velocidad del juego
               
       }
        
        
        
        
        }
    
    
    
    }
    
 void desplazar_der_cll(){               // Esta funcion desplaza al jugador hacia la derecha
      
      int der = jugador[7];    
      for(int i= 7; i>=0;i--){  
          jugador[i]=jugador[i-1];
          }
      jugador[0] = der;

    }

void desplazar_izq_cll(){               // Esta funcion desplaza al jugador hacia la izq
   
      int izq = jugador[0];
      for(int i= 0; i<8;i++){  
          jugador[i]=jugador[i+1];
          }
      jugador[7] = izq;

 }
 
void arriba_cll(){                      // Esta funcion desplaza al jugador hacia arriba
      
      int arb = 1;
      for(int i= 0; i<8;i++){  
          jugador[i]= jugador[i] << arb;
          }
      arb++;
      
    }
    
void pista_cll(){                       // Esta funcion ejecuta el movimiento de los vehiculos
    
    int aux = nivel[0];
      for(int i= 0; i<8;i++){  
          nivel[i]=nivel[i+1];
          }
      nivel[7] = aux;
    
    }  
    
void puntaje_cll(){                     // Esta funcion hace el conteo de los puntos ganados
      
      victorias[conteo]=0x80;       // cada vez que se llega al otro lado de la calle suma 1 punto que se visualiza en pantalla
      for(int i= 0; i<8;i++){       // Este ciclo for regresa al jugador a la pos 1
          jugador[i]= jugador[i] >> 6;  
          }
      ubicacion=1;                  // Renicializa la pos del jugador
      conteo++;                     // Cuenta cuantas veces a llegado el jugador al otro lado  hasta un maximo de 4
      if(conteo == 6){              // cuando el conteo es igual a 6 se llama a la funcion aumentar dificultad
         aumentar_dificultad_cll();
         }
         
    
      } 

void aumentar_dificultad_cll(){          // Esta funcion aumenta la dificultad del juego       
      
      for(int i= 0; i<8;i++){        // Regresa el valor de las victorias acumuladas a 0
          victorias[i]= 0;
          }
      velocidad = velocidad - 0.1;   // aumenta la velocidad del juego
      conteo=2;                      // reinicializa el conteo
       
      
      }
void reiniciar_calle(){             // Esta condicion renicia el sistema al estrellarce con un vehiculo
    
    NVIC_SystemReset();
    
    }    
void printstatus_cll()                  // Esta funcion es la encargada de la impresion
{
    
    for(int j= 1; j<=8;j++)         // Este cilo imprime en pantalla
        if (printjugador){
            sendSPI(j, nivel[j-1]|jugador[j-1]| victorias[j-1]);   // CADA VEZ que se vea en pantalla SPI se mostrar un dato en pantalla
            if((nivel[j-1] & jugador[j-1]) != 0){                  // SI este if se cumple el jugador ha sido chocado
               reiniciar_calle();                                  // Ee se hace llamado a la funcion reinicio
               }
               
            }else{
                sendSPI(j, nivel[j-1]| victorias[j-1]);            
                }
             
    printjugador =!printjugador;
} 


void tetris(){
     
     for(int i= 1;i<=8;i++){
          sendSPI(i, 0);
          }
          
     while(1){
            captura_datos_tx(); // Inicia la lectura de la informacion
            perder_tx();
            }
    
    }
    
void captura_datos_tx(){
         
        
         //-----------------------------------------
         char inicio=0,final=0;
         figura=0;
         giro=0;
         posicion=0;
         
         debuging("\n Ingrese el inicio del comando. ");
         inicio=pc.getc(); 
         debuging("\n Ingrese la Figura. ");
         figura=pc.getc();
         debuging("\n Seleccione el giro. ");
         giro=pc.getc();
         debuging("\n Seleccione la posicion. ");
         posicion=pc.getc(); 
         debuging("\n Ingrese el final del comando. ");
         final=pc.getc();   
         
        
          if(inicio!= '<' || final != '>'){
             
             debuging("\n Error en el comando.");
             
             }else{
                 
                 read_tx();
                  
                 }
          //------------------------------------------------------
          
         /*//--------------------figuras con random------------------
          figura=0;
          giro=0;
          figura=rand()%5;
          giro=rand()%5;
          posicion=rand()%6;;
          read_tx();
         *///--------------------------------------------------------
        
                 
         
 
    }
    
void inicializar(){ //INICIALIZA LA MATRIZ 
    
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);   
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0f,0);
        wait (0.5);
    }
    
    for (int j= 1; j<=8;j++){  // limpia la pantalla al encenderce o reiniarcea asi 
                               //no quedan leds encendidos cuando se ejecute el programa nuevamente
          
          sendSPI(j, 0x00);    //pone cada columna y vecto en blanco al inicializar
                            } 
    }
    
 void read_tx(){
         
         switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // L
             if(giro == 0)
             imprimir =  PZA_L,liminf=7, limizq=6, limder=0;
             if(giro == 1)
             imprimir =  PZA_LDN,liminf=7, limizq=5, limder=0;
             if(giro == 2)
             imprimir =  PZA_LDO,liminf=7, limizq=5, limder=-1;
             if(giro == 3)
             imprimir =  PZA_LDD,liminf=8, limizq=5, limder=0;
             break;
             case 1://T       
             if(giro == 0)
             imprimir =  PZA_T,liminf=8, limizq=5, limder=0;
             if(giro == 1)
             imprimir =  PZA_TN,liminf=7, limizq=6, limder=0;
             if(giro == 2)
             imprimir =  PZA_TO,liminf=7, limizq=5, limder=0;
             if(giro == 3)
             imprimir =  PZA_TD,liminf=7, limizq=5, limder=-1;
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             imprimir =  PZA_I,liminf=7, limizq=6, limder=-1;
             if(giro == 1 || giro == 3)
             imprimir =  PZA_IR,liminf=8, limizq=5, limder=0;
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             imprimir =  PZA_C,liminf=8, limizq=6, limder=0;
             break;
             case 4:
             if(giro == 0 || giro == 2)
             imprimir =  PZA_Z,liminf=8, limizq=5, limder=0;
             if(giro == 1 || giro == 3)
             imprimir =  PZA_ZN,liminf=7, limizq=6, limder=0;
             break;
             default:
             imprimir = VACIO;
             break;
             }
            // pc.printf("\n limite inferior read %d\n ",liminf);
             desplazar_tx();
     }    
  void desplazar_tx(){
      
      uint16_t desplazamiento[8]={0};      // Inicia un vector auxiliar con solo Ceros
      int j= 0;
       for(int i=posicion; i<(posicion+3);i++){  // Inicia un vector auxiliar con solo Ceros
           desplazamiento[i]=imprimir[j]; // Alamcena los nuevos datos tomados en el vector 
           j++;                    
                          }
       imprimir=desplazamiento;
       captura_matriz_tx();
      }  
      
void captura_matriz_tx(){
    
int i=0; // inicia el contador i en 0
int enable=1;
enableizq=1;
enableder=1;
bajando=1;
velocidad=1.0;
 while(enable){ //se encarga de desplazar los bits dentro del vector
    //pc.printf("\n1- conteo del corriemiento:\n %d",i);
    corrimiento=i;
    int j=1;  // inicia el contador j en 1 
     
    while(j<=8){ //se encarga de seleccionar que posicion del vector imprimira
         
         sendSPI(j, memoria[j-1]|(imprimir[j-1]>>i));  //Imprime el resultado de aplicar OR a la memoria y al desplamamiento de imprimir
         //wait(0.1); // Activar este wait para pruebas de desplazamiento y captura de los datos
 
     if(i==liminf || (memoria[j-1]&(imprimir[j-1]>>i+1))!=0){  //Detiene el desplazamiento cuando los bits tocan fondo, 
         enable=0;// desabilitador del ciclo while 
         bajando=0;
         for(int k=0; k<8;k++){                          // Almacena todos lo datos del vector en la posicion que corrimiento en la memoria
              memoria[k]= memoria[k]|(imprimir[k]>>i);
             }
    
     
         }
         
     /*//--------------------------analisis de casillas completadas----------
     
     
      int16_t MUL1 = memoria[0]& memoria[1]& memoria[2]& memoria[3];
      int16_t MUL2 = memoria[4]& memoria[5]& memoria[6]& memoria[7];

      
      MUL1= MUL1&MUL2;
      if(MUL1 != 0){
      
      //////////////////////////
      sendSPI(1, 0);
      sendSPI(2, 0);
      sendSPI(3, 0);
      sendSPI(4, MUL1);
      sendSPI(5, 0);
      sendSPI(6, 0);
      sendSPI(7, 0);
      sendSPI(8, 0);
      wait(1.0);
    ///////////////////////////////
          
      int16_t resta[8]={0};
      
      for(int ki=0; ki<=7;ki++){
          
          resta[ki]=memoria[ki]- MUL1;
          
          }

      int n=0;
      int cot=0b00000001;
      
      for(int l = 0; l<=7;l++){   
        if((cot<<l & MUL1) !=0){
            n++;
            }
        }
        
      for(int p= 1;p<=8;p++){
          sendSPI(p, resta[p-1]);
          
          }
       wait(2.0);
      
          
      
      for(int ii= 0;ii<=7;ii++){
          
          memoria[ii]=0;
          memoria[ii]= resta[ii]>>n;

          }
          
          }
      
     
     */
     //-----------------------------------------------------------------
     
        
     j++;
     } 
     wait(velocidad); // espera para tomar el otro valor de lectura
     // ----------------------Lectura del jostick-----------------------------
     
     meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X
     meas_vy = vry.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje Y
     
     //------ realiza el corriemiento del vector hacia la izq y der respectivamente.
  
 
  if (meas_vx > 1700 && (posicion < limizq))           // si se cumple esta condicion el jugador se desplaza a la izq
      desplazar_izq_tx(),i--; 
  else if (meas_vx < 1600 && (posicion > limder))      // si se cumple esta condicion el jugador se desplaza a la der
      desplazar_der_tx();
      

     //-----------------------Giro de la pieza--------------------------------
     
     if(meas_vy > 1680){
           giro++;       
           if(giro ==4){
               giro=0;
               }
           switch(figura){
             case 0: // L
             if(giro == 0)
             imprimir= girar(PZA_L, posicion),liminf=7, limizq=6, limder=0,i--;
             if(giro == 1)
             imprimir= girar(PZA_LDN, posicion),liminf=7, limizq=5, limder=0,i--;
             if(giro == 2)
             imprimir= girar(PZA_LDO, posicion),liminf=7, limizq=5, limder=-1,i--;
             if(giro == 3)
             imprimir=girar(PZA_LDD, posicion),liminf=8, limizq=5, limder=0,i--;
             break;
             case 1://T       
             if(giro == 0)
             imprimir= girar(PZA_T, posicion),liminf=8, limizq=5, limder=0,i--;
             if(giro == 1)
             imprimir= girar(PZA_TN, posicion),liminf=7, limizq=6, limder=0,i--;
             if(giro == 2)
             imprimir= girar(PZA_TO, posicion),liminf=7, limizq=5, limder=0,i--;
             if(giro == 3)
             imprimir= girar(PZA_TD, posicion),liminf=7, limizq=5, limder=-1,i--;
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_I, posicion),liminf=7, limizq=6, limder=-1,i--;
             if(giro == 1 || giro == 3)
             imprimir=girar(PZA_IR, posicion),liminf=8, limizq=5, limder=0,i--;
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             imprimir= girar(PZA_C, posicion),liminf=8, limizq=6, limder=0,i--;
             break;   
             case 4: //Z
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_Z, posicion),liminf=8, limizq=5, limder=0,i--;
             if(giro == 1 || giro == 3)
             imprimir= girar(PZA_ZN, posicion),liminf=7, limizq=6, limder=0,i--;
             break;
 
             }

             }
     
     //---------------------------------------------------------------
     pulsador_abj.fall(&aum_velocidad_tx);

     i++;
     }
 
  }
  
  void desplazar_izq_tx(){
     
      if(posicion<limizq & corrimiento<liminf & enableizq){
          posicion++;
          
            for(int i=7; i >=0; i--){
                imprimir[i]=imprimir[i-1];
                if(i==0){
                    imprimir[i]=0;
                    
                    } 
                if((memoria[i+1] & (imprimir[i]>>corrimiento))!=0){
                    enableizq=0;
                    }      
                            
                }
            for(int j=1;j<=8;j++){
             sendSPI(j, memoria[j-1]|(imprimir[j-1]>>corrimiento));
 
                 }   
            wait(1.0);  
          
          }
      return;
      }
      
  void desplazar_der_tx(){
      if(posicion>limder & corrimiento<liminf & enableder & bajando){
           posicion--;
           
            for(int i=0; i <8; i++){
                int der =(memoria[i+1] & (imprimir[i]>>corrimiento));
                imprimir[i]=imprimir[i+1];
                if(i==7){
                    imprimir[i]=0;
                    
                    }
                if((memoria[i-1] & (imprimir[i]>>corrimiento))!=0){
                    enableder=0;
                    pc.printf("\n multisder en :%d\n ",der);
                    pc.printf("\n derecho:%d\n ",enableder);
                    }     
                }    
            for(int j=1;j<=8;j++){
                 sendSPI(j, memoria[j-1]|(imprimir[j-1]>>corrimiento));
                 }   
            wait(1.0); 
      }
      return;
     
  } 
      
  uint16_t* girar(uint16_t* pieza, int posicion){
     uint16_t desplazamiento[8]={0};                      
     int j= 0;
     for(int i=posicion; i<(posicion+3);i++){  // Inicia un vector auxiliar con solo Ceros
     desplazamiento[i]=pieza[j]; // Alamcena los nuevos datos tomados en el vector 
     j++;                    
     }
    
    return desplazamiento;
    }
    
 void perder_tx(){
     for(int i=0; i<8;i++){                          // Almacena todos lo datos del vector en la posicion que corrimiento en la memoria
        borde= &memoria[i];
        if(*borde>255){
          
          for(int r=0; r<8; r++){
              
              memoria[r]=0;
              
              }
          
          }
        }
    }  
    
 void  aum_velocidad_tx(){
     velocidad=0.2;
     } 
 
 void himno_legria(){
     
    int i;
        buzzer=0.2;
        for (i=0; i<13; i++) {
            buzzer.period_us(periodos1[i]);
            wait(0.5*duracion1[i]);
        }
        for (i=0; i<13; i++) {
            buzzer.period_us(periodos2[i]);
            wait(0.5*duracion1[i]);
        }
        for (i=0; i<16; i++) {
            buzzer.period_us(periodos3[i]);
            wait(0.5*duracion2[i]);
        }    
    NVIC_SystemReset();
}    


// Funciones del carro

void carros(){
    
     while(1){

        selec();

        }
    
    }
void selec(){
   
   figura=rand()%4;
   
   switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // carro derecha
             nivel = CR_DER;
             break;
             case 1: // carro izquierda       
             nivel = CR_IZQ;
             break;
             case 2: // caja derecha
             nivel = CJ_DER;
             break;
             case 3: // caja izquierda
             nivel = CJ_IZQ;
             break;
             }
       
       juego();
       
   }  
 
 
 void juego(){
 
   jugador=MICARRO;
   camino= CALLE;
   fail=EQUIS;
   //tp.attach(&printstatus,0.2);
   enable_abj=1;
   enable_der=1;
   enable_izq=1;
   // Declaracion de Variables de lectura del jostick
   float meas_vx;
   int i=0;
 
while(enable_abj){

    int j=1;  // inicia el contador j en 1 
     
    while(j<=8){ //se encarga de seleccionar que posicion del vector imprimira
         
         sendSPI(j, jugador[j-1]|(nivel[j-1]>>i)|camino[j-1]);  //Imprime el resultado de aplicar OR a la memoria y al desplamamiento de imprimir
         //wait(0.1); // Activar este wait para pruebas de desplazamiento y captura de los datos
 
     if(i==13){  //Detiene el desplazamiento cuando los bits tocan fondo, 
         enable_abj=0;// desabilitador del ciclo while 
         }  
     if((jugador[j-1]&(nivel[j-1]>>i))!=0){
         
         NVIC_SystemReset();
         
         }  
     j++;
     } 
     wait(velocidad_cr); // espera para tomar el otro valor de lectura
     // ----------------------Lectura del jostick-----------------------------
     
     // Lectura de parametros del jostick
     meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X

    if (meas_vx < 1600 && enable_izq)
           desplazar_izq(); 
    else if (meas_vx > 1700 && enable_der)
           desplazar_der();
     i++;
     pulsador_abj.fall(&aum_velocidad_cr);
     }
}
     
void desplazar_izq(){
      
      enable_der=1;
      posicion_fig--;
      
      
      if(posicion_fig==2)
         enable_izq=0;
      
      
      int izq = jugador[0];
      for(int i= 0; i<8;i++){  
          jugador[i]=jugador[i+1];
          }
      jugador[7] = izq; 
    
}

void desplazar_der(){
      
      enable_izq=1;
      posicion_fig++;
      
      if(posicion_fig==5)
         enable_der=0;
          
      int der = jugador[7];
      for(int i= 7; i>=0;i--){  
          jugador[i]=jugador[i-1];
          }
      jugador[0] = der;
      
    }

 void  aum_velocidad_cr(){
     velocidad_cr=0.2;
     } 
 