
#include "mbed.h"
#include <math.h>
#include "Piezas.h"
Serial pc(USBTX,USBRX);  
SPI deviceM(PB_5, PB_4, PB_3);  // D4(gris), Ninguno, D3(azul)
DigitalOut ssel (PA_4);         // A2(morado)

InterruptIn pulsador_izq(A0);
InterruptIn pulsador_der(A4);



int imprimir[8] = {0,0,0,0,0,0,0,0};

uint16_t FIG_C[8]=      {0b00000011,
                         0b00000111,
                         0b11111111,
                         0b00000111,
                         0b00001111,
                         0b00011111,
                         0b00000111,
                         0b00000111};
float vel=0.1;

void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};
 
void inicializar_matriz(){
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);    //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0F,0);
        wait (0.5);
    }
  
  }


  
int main() {
                   
   inicializar_matriz();
   pc.baud(38400);
   
   while(1){
      /////////////////////////////////
      for(int i= 1;i<=8;i++){
          sendSPI(i, FIG_C[i-1]);
          
          }
      /////////////////// 
      wait(2.0);
      
      int16_t MUL1 = FIG_C[0]& FIG_C[1]& FIG_C[2]& FIG_C[3];
      int16_t MUL2 = FIG_C[4]& FIG_C[5]& FIG_C[6]& FIG_C[7];

      
      MUL1= MUL1&MUL2;
     
     //////////////////////////
      sendSPI(1, 0);
      sendSPI(2, 0);
      sendSPI(3, 0);
      sendSPI(4, MUL1);
      sendSPI(5, 0);
      sendSPI(6, 0);
      sendSPI(7, 0);
      sendSPI(8, 0);
      wait(1.0);
    ///////////////////////////////
    
    
      int16_t resta[8]={0};
      int16_t memoria[8]={0};
      
      for(int ki=0; ki<=7;ki++){
          
          resta[ki]=FIG_C[ki]- MUL1;
          
          }
      ///////////////////////////////    
      for(int i= 1;i<=8;i++){
          sendSPI(i, resta[i-1]);
          
          }
       wait(2.0);
      /////////////////////////////////
      int n=0;
      int cot=0b00000001;
      
      for(int l = 0; l<=7;l++){   
        if((cot<<l & MUL1) !=0){
            n++;
            }
        }
      
      for(int i= 1;i<=8;i++){
          
          memoria[i-1]= 0;

          }
      
      ////////////////
      for(int i= 1;i<=8;i++){
          
          memoria[i-1]= resta[i-1]>>n;

          }
       wait(0.2);
      //////////////////////////////// 
       /*    
      int A = 0b01110111;
      int B = 0b00011100;
      int C = A&B;
      int R= A-C;
      int cot=0b00000001;
      
    int n=0;
    
    for(int l = 0; l<=7;l++){
        
        if((cot<<l & R) !=0){
            n++;
            
            }
        }
      pc.printf("\n n %i\n ",n);

      pc.printf("\n n-1 %i\n ",n);
      

       float acum=1;
       for(int t=1;t<=n;t++){
           acum*=2;         
           }
       acum--;
      
      
      
      pc.printf("\n k %i\n ",acum);
      
      sendSPI(1, A);
      sendSPI(2, B);
      sendSPI(3, C);
      sendSPI(4, R);
      sendSPI(5, 0);
      sendSPI(6, cot);
      sendSPI(7, 0);
      sendSPI(8, acum);
      wait(vel);
      
      */  
                       
       }

}



