#include "mbed.h"

// User defined mbed LED Lightshow
// Working Code 27 Nov 2010

// Data entries = LED instance
// Data = 91111 = all 4 LEDs on
// Data = 90000 = all 4 LEDs off
// Data = 90110 = LEDs 1 and 4 off, 2 and 3 on
// Data value 9 prevents processing data as octal values
// Data value 9 may be future LED duration timing code (values 1-9)

DigitalOut myleda(LED1);
DigitalOut myledb(LED2);
DigitalOut myledc(LED3);
DigitalOut myledd(LED4);

int nDisplayTemp;
int i;

// Set number in array ( nDisplay[x] ) = number of data entries
// Set loop value below to equal number of data entries in array

int nDisplay[100]={                                                         
                    91000,90100,90010,90001,91000,90100,90010,90001,91000,90100,      // 1:  0 - 09 light display
                    90010,90001,91000,90100,90010,90001,90000,91111,90110,91001,      // 2: 10 - 19 light display1111,90111,91011,91101,91110,91111,90110,91101,91011,91111};     //10: 90 - 99 light display
                    90110,91111,90000,90001,90010,90100,91000,90001,90010,90100,      // 3: 20 - 29 light display
                    91000,90001,90010,90100,91000,90001,90010,90100,91000,90000,      // 4: 30 - 39 light display
                    91111,90110,91001,90110,91001,90110,91111,90000,91000,91100,      // 5: 40 - 49 light display
                    91110,91111,90111,90011,90001,90000,90001,90011,90111,91111,      // 6: 50 - 59 light display
                    91110,91100,91000,90000,91111,91001,90110,91001,91111,91111,      // 7: 60 - 69 light display
                    90111,90011,90001,91000,91100,91110,91111,90000,91110,91101,      // 8: 70 - 79 light display
                    91011,90111,91110,91100,91000,90000,91111,91000,91100,91110,      // 9: 80 - 89 light display
                    91111,90111,91011,91101,91110,91111,90110,91101,91011,91111};     //10: 90 - 99 light display
int main() {
    while (1){
    
    // Set loop value to equal number of data entries in array
    
    for (int i=0; i<100; i++) {                                             
    if (nDisplay[i]>=91000)                                                   // light no 1 : on or off
    {   myleda = 1;
        nDisplayTemp = nDisplay[i] - 1000;
        }
    else
    {   myleda = 0;
        nDisplayTemp = nDisplay[i];
        }
    if (nDisplayTemp >= 90100)                                               // light no 2 : on or off
    {   myledb = 1;
        nDisplayTemp = nDisplayTemp - 100;
        }
    else
    {   myledb = 0;
        }
    if (nDisplayTemp >= 90010)                                               // light no 3 : on or off
    {   myledc = 1;
        nDisplayTemp = nDisplayTemp - 10;
        }
    else
    {   myledc = 0;
        }
     if (nDisplayTemp >= 90001)                                              // light no 4 : on or off
     {  myledd = 1;
        }
     else
     {  myledd = 0;
        }   
  
        wait(0.2);
        myleda = myledb = myledc = myledd = 0;                              // 0.2 sec : all lights off
        wait(0.2);
    }
   }
}
