/*
For whatever reason the Watchdog timer cannot be made to work on a KL25Z using MBED.
This example is based on Sw_reset by Peter Andersson.
It uses a ticker routine that checks if random number generated in the main loop has not changed since the last ticker interrupt,
an indication that the main loop has frozen. Once this condition is detected a pin, PTB10 in this example, is forced low.
If this is linked to the opposite reset pin of the KL25Z be board will be restarted.

*/

#include "mbed.h"

void wd_check(void);                            //Define the watchdog check function "wd_check"

Ticker watchdog;                                //Define a Ticker with the name "watchdog"


//DigitalOut led(LED1);
DigitalOut      blueled  (LED_BLUE);
DigitalOut      greenled (LED_GREEN);
DigitalOut      redled   (LED_RED);
DigitalInOut    rst      (PTB10);               //Connect this to the reset pin

Serial pc(USBTX,USBRX);                         //Send diagnostics via USB serrial port

int iHang;                                      //Hangup counter    
int timeout;                                    //Main loop generated random number
int timeout1;                                   //Previous randon number

//Ticker interrupt code
void wd_check()                                 //the function that Ticker will call
{
    blueled=!blueled;                           //toggle the blue LED
    if (timeout1==timeout){                     //Is the new timeout randon number the same as the last
        rst.output();                           //If so the main loop must have frozen
        rst.write(0);                           //so force a hardware reset
        }                                       //else 
    timeout1=timeout;                           //Store current timeout as the old number ready for next interrupt
}                                               //return

//Main Program
int main() {
    greenled = 1;                               //Off
    redled = 1;                                 //Off
   
    blueled = 0;                                //turn on blue BEFORE we test comms
    pc.printf("Hello World!\r\n");              //Show that the code has started running at the beginning
    greenled = 0;                               //turn on  Green AFTER we tested comms

    watchdog.attach(&wd_check, 2);              //Initialise the ticker
    
    int iHang = 0;                              //Initialise our loop counter to Zero

    while(1) {                                  //The start of the 'forever' main loop
        pc.printf("loop %d\r\n", iHang);        //Show that we are looping
        wait(0.1);                              //wait .1 second
        iHang++;                                //Count the number of times we have prevented a reboot
        timeout== rand();                       //set timeout to a random number if this doesn't change then the program must have frozen

        if(iHang == 10) {                       //after 10 times round the loop...
            blueled = 1;                        //turn off Blue
            greenled = 1;                       //turn off Green
            redled = 0;                         //turn on  Red
            while(1) ;                          //Stall the program until the watchdog resets the micro'
        }
    }                                           //End of 'forever' loop
}
