/* Grove - Temprature Sensor demo v1.0
*  This sensor detects the enviroment temprature,
*  Uses a Arch-Pro board with Grove Base Shield
*  Connect the Grove Temperature sensor to A0 and
*  connect a Grove 4 digit LED display to the UART connector
*  The temperature will be displayed in Celcius
*  Modified by David Bottrill from the original Arduino code
*  By: http://www.seeedstudio.com
*/

#include "mbed.h"
#include "DigitDisplay.h"

DigitalOut myled(LED1);

DigitDisplay display(P4_29, P4_28);
AnalogIn ain(P0_23);

int a;
float temperature;
int B=3975;                                                         //B value of the thermistor
float resistance;

int main()
{
    while(1) {
// multiply ain by 675 if the Grove shield is set to 5V or 1023 if set to 3.3V
        a=ain*675;
        resistance=(float)(1023-a)*10000/a;                         //get the resistance of the sensor;
        temperature=1/(log(resistance/10000)/B+1/298.15)-273.15;    //convert to temperature via datasheet ;
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
        display.write(temperature);
    }
}


