//******************************************************************************************
//  Verison : 1.0.0.0   9.8.2017    Startversion

//***************** INCLUDES ***************************************************************
#include "mbed.h"
#include "string.h"

//***************** PROTOTYPES *************************************************************
void pc_isr();
void parse_pc(char*);
void MyTicker_isr();

//***************** HARDWARE RECOURCES *****************************************************

Ticker MyTicker;

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);    // tx, rx
//Serial Gps(A7,A2);        // tx, rx
Serial Remote(D1,D0);       // tx, rx
PwmOut Mypwm0(D3);
PwmOut Mypwm1(D6);
AnalogIn Is_1(A0);
AnalogIn Is_2(A1);
AnalogIn T_2(A3);
AnalogIn T_1(A4);
AnalogIn Poti(A5);
AnalogIn V_Supp(A6);

DigitalOut Myled(LED1);
DigitalOut Mode0(D10);
DigitalOut RunStop_1(D5);
DigitalOut RunStop_2(D4);
DigitalOut Ext_Sup(D2);
DigitalIn  Taster(D11);

void pc_isr();
void parse_pc(char*);

//***************** GLOBAL VARIABLES *******************************************************
#define RX_BUFFER_PC_SIZE 255
char rx_buffer_pc[RX_BUFFER_PC_SIZE] = {' '};
char stringcopy_isr_pc[RX_BUFFER_PC_SIZE] = {' '};
char stringcopy_pc[RX_BUFFER_PC_SIZE] = {' '};
int  rx_buffer_pc_poi = 0;
bool stringComplete_pc = false;  // whether the string is complete
char c;

//***************** THE MAIN PROGRAM ******************************************************* 
int main() {
//***************** INIT ******************************************************************* 
    float meas;    
//**************** Setup ***************  
    MyTicker.attach(&MyTicker_isr, 0.2);
    Remote.baud(115200);
    pc.baud(115200);  
    Remote.printf("Hello World Remote\n");
    pc.printf("Hello World PC\n");
    HAL_Delay(200);
    Mypwm0.period_us(100);
    Mypwm0.pulsewidth_us(2);
    Mypwm1.period_us(100);
    Mypwm1.pulsewidth_us(1);
    Ext_Sup = 0;
    RunStop_1 = 1;
    RunStop_2 = 1;
    Mode0 = 0;
    Myled = 0;
    Myled = !Myled;
    wait(0.5);
    Myled = !Myled;
    pc.attach(&pc_isr);
//**************** MAIN LOOP ***************************************************************      
    while(1) {
 /*       if (stringComplete_pc)                       //  set in interrupt
            {
            strncpy(stringcopy_pc, stringcopy_isr_pc, (unsigned)strlen(stringcopy_isr_pc));  
            parse_pc(stringcopy_pc);                 //  handle it and respond
            stringComplete_pc = false;               // reset
            Myled = !Myled;
            }  */       
        meas = Poti.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        Remote.printf("Poti = %.0f mV\n", meas);
        wait(1);
        meas = V_Supp.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        meas = (meas * 110.0f) / (float)10.0f;
        meas /= 1000.0f;
        meas *= 1.02f;
        meas -= 0.02f;
        Remote.printf("V_Supp = %.02f V\n", meas);
        wait(1);       
        Ext_Sup = !Ext_Sup;
    }
}


//***************** PARSING PC COMMAND ******************************************************

void parse_pc(char* stringcopy)
{ 
char cmd;

if (stringcopy_pc[0] != '#')
  {
  pc.printf("@Syntax Error\r\n");
  return;
  } 
cmd = stringcopy_pc[1];  
switch(cmd)
  {
// Testing ....
    case 'v': pc.printf("Hello world ! v ! \r\n");
    break;            
    case 'a': pc.printf("Hello world ! a ! \r\n");
    break;
    }
 }


//***************** PC ISR *****************************************************************
void pc_isr() {
    if (pc.readable()) {
       do {
            c = pc.getc();
            rx_buffer_pc[rx_buffer_pc_poi] = c;
            rx_buffer_pc_poi++;
            if (c == '\n')
                {
                stringComplete_pc = true;
                strncpy(stringcopy_isr_pc, rx_buffer_pc, rx_buffer_pc_poi);
                rx_buffer_pc_poi=0;
                }
        }
        while (rx_buffer_pc_poi < RX_BUFFER_PC_SIZE && (c != '\n') && pc.readable());
    }
}

//***************** TICKER ISR MyTICKER ****************************************************
void MyTicker_isr()
{
   if (stringComplete_pc)                       //  set in interrupt
      {
      strncpy(stringcopy_pc, stringcopy_isr_pc, (unsigned)strlen(stringcopy_isr_pc));  
      parse_pc(stringcopy_pc);                 //  handle it and respond
      stringComplete_pc = false;               // reset
      }  
   Myled = !Myled; 
}
//***************** THE END **************************************************************** 