#include "mbed.h"
#include "LCD_DISCO_F746NG.h"

LCD_DISCO_F746NG lcd;
DigitalOut LCD_D5(D5); 


AnalogIn input0(A0);
AnalogIn input1(A1);
AnalogIn input2(A2);
AnalogIn input3(A3);
AnalogIn input4(A4);
AnalogIn input5(A5);

// drawHomeScreen - Custom Function
void drawHomeScreen() {
    lcd.Clear(LCD_COLOR_GREEN);

    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"MBED EXAMPLE", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"HOME SCREEN", RIGHT_MODE);
}

// drawAnalogScreen - Custom Function
void drawAnalogScreen() {
    lcd.Clear(LCD_COLOR_BLUE);
    
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"A0", LEFT_MODE);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"A1", LEFT_MODE);
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"A2", LEFT_MODE);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"A3", LEFT_MODE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"A4", LEFT_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"A5", LEFT_MODE);

    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"ANALOG SCREEN", RIGHT_MODE);
}



int main()
{  
    char currentPage, selectedUnit;
    drawHomeScreen();
    wait(2);  
    drawAnalogScreen();
    
    while(1)
    {
      
       LCD_D5 = 1;
      
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      //lcd.Clear(LCD_COLOR_BLUE);

        double meas0 = (5*input0.read_u16())/(double)65535; 
        char strarray0[50];           
        sprintf(strarray0, "  %f  ", meas0);
        
        uint16_t meas1 = input1.read_u16(); 
        char strarray1[50];           
        sprintf(strarray1, "  %d  ", meas1);
        
        uint16_t meas2 = input2.read_u16(); 
        char strarray2[50];           
        sprintf(strarray2, "  %d  ", meas2);
        
        uint16_t meas3 = input3.read_u16(); 
        char strarray3[50];           
        sprintf(strarray3, "  %d  ", meas3);
        
        uint16_t meas4 = input4.read_u16(); 
        char strarray4[50];           
        sprintf(strarray4, "  %d  ", meas4);
        
        uint16_t meas5 = input5.read_u16(); 
        char strarray5[50];           
        sprintf(strarray5, "  %d  ", meas5);
        


        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)strarray0, RIGHT_MODE);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)strarray1, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)strarray2, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)strarray3, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)strarray4, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)strarray5, CENTER_MODE);

        
        //lcd.Clear(LCD_COLOR_BLUE);
        //lcd.SetTextColor(LCD_COLOR_BROWN);
        //lcd.DrawCircle(200, 200, meas0/10);
          
        wait(0.160f);
     }
     
      lcd.Clear(LCD_COLOR_GREEN);      
      lcd.SetTextColor(LCD_COLOR_BLUE);
      lcd.DrawRect(10, 20, 50, 50);
      wait(0.1);
      lcd.SetTextColor(LCD_COLOR_BROWN);
      lcd.DrawCircle(80, 80, 50);
      wait(0.1);
      lcd.SetTextColor(LCD_COLOR_YELLOW);
      lcd.DrawEllipse(150, 150, 50, 100);
      wait(0.1);
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.FillCircle(200, 200, 40);
      wait(1);

      lcd.SetBackColor(LCD_COLOR_ORANGE);
      lcd.SetTextColor(LCD_COLOR_CYAN);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"HAVE FUN !!!", CENTER_MODE);
      wait(1);

     // pin5 = !pin5;
    
}
