#include "mbed.h"
#include "C027.h"
#include "WANDongle.h"
#include "USBSerialStream.h"
#include "UbloxCDMAModemInitializer.h"
#include "UbloxGSMModemInitializer.h"

DigitalOut mdm_activity(LED);

int main() 
{
    int led_toggle_count = 5;

    // the instantiation of the type, calls C027::C027
    C027 c027;
    
    c027.mdmPower(true,false);
    
    // enable the GPS, and connect it 
    // to the m3.
    c027.gpsPower(true, false);

#if 0
    while(1) {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#else
    while( led_toggle_count-- > 0 )
    {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#endif
        
    // open the mdm USB port
    WANDongle mdmDongle;
    USBSerialStream mdmStream(mdmDongle.getSerial(1/* the CDC usually 0 or 1, LISA-C requires CDC1*/));
    USBHost* host = USBHost::getHostInst();
    mdmDongle.addInitializer(new UbloxCDMAModemInitializer(host));
    mdmDongle.addInitializer(new UbloxGSMModemInitializer(host));
   
    // open the PC serial port.
    Serial pc(USBTX, USBRX);
    pc.baud(MDMBAUD);
    
    pc.printf( "M3->USB CDC connection ready\r\n");
    
    while (1)
    {
        uint8_t buf[64];
        size_t len;
        int i;
        
        if (!mdmDongle.connected())
        {
            mdmDongle.tryConnect();
        }
        else
        {
        
            // transfer data from pc to modem
            len = mdmStream.space();
            if (len>0)
            {
                if (len > sizeof(buf))
                    len = sizeof(buf);
                for (i = 0; (i < len) && pc.readable(); )
                    buf[i++] = pc.getc();
                if (OK == mdmStream.write(buf, i))
                    /* do something? */;
            }
            // transfer data from modem to pc
            len = mdmStream.available();
            if ((len>0) && pc.writeable())
            {
                if (len > sizeof(buf))
                    len = sizeof(buf);
                if (OK == mdmStream.read(buf, &len, len))
                {
                    for (i = 0; (i < len); ) 
                    {
                        mdm_activity=!mdm_activity;
                        pc.putc(buf[i++]);
                    }
                    
                    // default the led to off 
                    mdm_activity=0;
                }
            }
        }
    }
}
