#include "mbed.h"
#include "C027.h"

DigitalOut mdm_activity(LED);

int main() 
{
    int led_toggle_count = 5;

    C027 c027;
    
    // enable, and use the uart
    c027.mdmPower(true,true);
    
    // enable the GPS.
    c027.gpsPower(true, false); 
    
#if 0
    while(1) {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#else
    while( led_toggle_count-- > 0 )
    {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#endif

    // open the mdm serial port
    Serial mdm(MDMTXD, MDMRXD);
    mdm.baud(MDMBAUD);
    // tell the modem that we can always receive data
    DigitalOut mdmRts(MDMRTS);
    mdmRts = 0; // (not using flow control)
    
    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(MDMBAUD);
    
    pc.printf( "M3->UART connection ready\r\n");
    
    while (1)
    {
        // transfer data from pc to modem
        if (pc.readable() && mdm.writeable())
            mdm.putc(pc.getc());
        // transfer data from modem to pc
        if (mdm.readable() && pc.writeable()) 
            pc.putc(mdm.getc());
    }
}
