#include "mbed.h"
#include "C027.h"

int main() 
{
    C027 c027;
    c027.gpsPower(true,false);
    
    int baud = GPSBAUD;
    
    // open the gps serial port
    Serial gps(GPSTXD, GPSRXD);
    gps.baud(baud);
    
    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(baud);
    
    while (1)
    {
        // transfer data from pc to gps
        if (pc.readable() && gps.writeable())
            gps.putc(pc.getc());
        // transfer data from gps to pc
        if (gps.readable() && pc.writeable())
            pc.putc(gps.getc());
    }
}
