#include "mbed.h"
#include "C027.h"

int main()
{
    Timer tmr;
    tmr.start();
    C027 c027;
    c027.gpsPower(true,false);

    // open the gps i2c port
    I2C gps(GPSSDA, GPSSCL);
    gps.frequency(100000);

    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(GPSBAUD);
    
    int s = 0;
    int i = 0;
    int o = 1; 
    char in[1024];
    char out[1024] = { 0xFF/*STREAM_REG*/, 0x00 /* ... */ };
    while (1) 
    {
        // transfer data from pc to gps
        if (pc.readable() && (o < sizeof(out)))
            out[o++] = pc.getc();
        if (pc.writeable() && i < s) 
            pc.putc(in[i++]);
    
        if (tmr.read_ms() > 50)
        {
            const char r = 0xFD /*LENGTH_REG*/; 
            unsigned char sz[2];
            if (0 == gps.write(GPSADR,&r,sizeof(r), true))
            {
                if (0 == gps.read(GPSADR,(char*)sz,sizeof(sz),true))
                {
                    int b  = (int)sz[0];
                    b *= 256;
                    b += sz[1];
                    if (i == s)
                        i = s = 0;
                    if (b > sizeof(in)-s) 
                        b = sizeof(in)-s;
                    if (b > 0) 
                    {
                        if (0 == gps.read(GPSADR,&in[s],b,true))
                            s += b;
                    }
                }
            }
            gps.stop();
            if (o > 1)
            {
                if (0 == gps.write(GPSADR,out,o))
                    o = 0;
            }
            tmr.reset();
        }
    }
}
