#include "mbed.h"
#include "C027.h"

DigitalOut mdm_activity(LED);

int main() 
{
    int led_toggle_count = 5;
   
#if 0
    while(1) {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#else
    while( led_toggle_count-- > 0 )
    {
        mdm_activity = !mdm_activity;
        wait(0.2);
    }
#endif

    // open the external serial port
    Serial m3(D1, D0);
    m3.baud(MDMBAUD);
    
    // open the USB console port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(MDMBAUD);
    
    if ( m3.writeable() ) pc.printf("m3 is writable\r\n");
    if ( m3.readable() ) pc.printf("m3 is readable\r\n");
    
    pc.printf( "M3->EXT UART connection ready\r\n");
    
    m3.printf( "TESTING\r\n");
    
    while (1)
    {
        // transfer data from pc to modem
        if (pc.readable() && m3.writeable())
            m3.putc(pc.getc());
        // transfer data from modem to pc
        if (m3.readable() && pc.writeable()) 
            pc.putc(m3.getc());
    }
}
