#include "mbed.h"
#include "C027.h"
#include "Ethernet.h"
#include "hexview.h"

using namespace mbed;

DigitalOut led4(LED);

Ethernet eth;
Serial pc(USBTX, USBRX);

unsigned short htons(unsigned short n) {               // Host short to network shor
  return ((n & 0xff) << 8) | ((n & 0xff00) >> 8);      // Byte swapping
}

void show(char *buf, int size) {
    pc.printf("Destination:  %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n\r",
            buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
    pc.printf("Source: %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n\r",
            buf[6], buf[7], buf[8], buf[9], buf[10], buf[11]);
  
    pc.printf("Type %hd\n\r", htons((short)buf[12]));
    
    hexview(buf, size);
}


int main() {
    char buffer[0x600];
    int size = 0;
    int led_toggle_count = 5;
    
 #if 0
    while(1) {
        led4 = !led4;
        wait(0.2);
    }
#else
    while( led_toggle_count-- > 0 )
    {
        led4 = !led4;
        wait(0.2);
    }
#endif

   // open the PC serial port and (use the same baudrate)
    pc.baud(MDMBAUD);
    
    pc.printf( "Start ETHERNET Sniff Testing\n\r");
    
    while(1) {
        if((size = eth.receive()) != 0) {
            led4=!led4;
            eth.read(buffer, size);
            show(buffer, size);
        }
    }
}
