#include "mbed.h"
#include "C027.h"

Ticker ticker;
DigitalOut led1(LED);
DigitalOut led2(LED1);
CAN can1(CANRD, CANTD);
Serial pc(USBTX, USBRX);

char counter = 0;

// this function creates a CAN message with a counter in it
//   and sends it on the CAN interface
void send() {
    if(can1.write(CANMessage(1337, &counter, 1))) {
        pc.printf("Message sent: %d\r\n", counter);
        counter++;
    }
    led1 = !led1;
}

int main() {

    DigitalOut can_standby(CANS);
    
    // enable the CAN interface
    //   take it out of standby
    can_standby = 0;
    
    // specify the baud rate for communications
    //   with the serial console to the PC host.
    pc.baud(MDMBAUD);
    
    pc.printf( "Starting CAN Testing\r\n");

    CANMessage msg;
    while(1) {

        if(can1.read(msg)) {
            pc.printf("Message received: %d\r\n", msg.data[0]);
            led2 = !led2;
        }
        
        wait(0.2);
        
        // send a new message.
        send();
    }
}


