#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"
 
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    Serial pc(USBTX, USBRX); // tx, rx
 
 
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
 
    while (true) {
        float x, y, z;
        
        float lower_th, upper_th;
        
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        //
        Thread::wait(300);
        
        if(z>= 0.9 ){ // flat
           // myled1 = 0;
           
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("flat \n \r");
                        
        }else if(y>= 0.9 ){//right
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("right \n \r");
            
        }else if(x>= 0.9){ // dowm
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("down \n \r");
            
        }else if(z<= -0.90 ){ //over
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("over \n \r");
            
        }else if(y<= -0.90 ){ 
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("left \n \r");
            
        }else if(x<= -0.90 ){
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("up \n \r");
            
        }
        
        else{
            
            rled = 1;
            gled = 1;
            bled =1;
            pc.printf(" \n \r");
        }
        //
       // pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f \n \r", x, y, z);
    }
}