
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"


Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalIn b1(D15, PullUp);
//DigitalOut led1(LED_RED);   // Red LED
DigitalOut ledy(PTD5);
DigitalOut ledb(PTA13);
DigitalOut ledr(PTD0);
DigitalOut ledw(PTD2);
DigitalOut ledg(PTD3);
volatile int pressEvent = 0 ;  
Serial pc(USBTX, USBRX); // tx, rx, for debugging



enum buttonPos { up, down, bounce }; // Button positions
void polling() {
    buttonPos pos = up ;//chose positing in enum
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ;
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }
}

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;
Thread pollT ; // thread to poll
void buttonCallback(){
    pressEvent = 1 ;
}
// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    bool max_volt = false;
    pollT.start(callback(polling));//start thread to check button
    int volts = 0 ;
    int threshold[6] = {55,110,165,220,275,330} ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
     
        if(pressEvent)
        {
            pressEvent=0;
            max_volt = !max_volt;
            }
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
      
            if(volts <=(threshold[0]) and (max_volt==false)){
                ledy = 0;
                ledb = 0;
                ledr = 0;
                ledw = 0;
                ledg = 0;    
                }
            else if(volts >=(threshold[0])&&volts <=(threshold[1] and max_volt==false)){//1.1 && volts < 1.65){
                ledy = 1;
                ledb = 0;
                ledr = 0;
                ledw = 0;
                ledg = 0;   
                }
            else if(volts >=(threshold[1])&&volts <=(threshold[2] && max_volt==false)){
                ledy = 1;
                ledb = 1;
                ledr = 0;
                ledw = 0;
                ledg = 0;  
                }
            else if(volts >=(threshold[2])&&volts <=(threshold[3]) and max_volt==false){
                ledy = 1;
                ledb = 1;
                ledr = 1;
                ledw = 0;
                ledg = 0; 
                }
            else if(volts >=(threshold[3])&&volts <=(threshold[4]) and max_volt==false){
                ledy = 1;
                ledb = 1;
                ledr = 1;
                ledw = 1;
                ledg = 0;  
                }   
            else if(volts >=(threshold[4])&&volts <=(threshold[5]) and max_volt==true){
                ledy = 1;
                ledb = 1;
                ledr = 1;
                ledw = 1;
                ledg = 1;  
                }  
                if(volts>=(threshold[5])){
                    max_volt=false;
                    
                    }
                    else{}
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }
    }
}
