#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);
InterruptIn button2(PTD5);
DigitalOut led(LED_BLUE);
DigitalOut led1(LED_RED);

volatile int pressEvent = 0 ;
volatile int pressEvent2 = 0;
volatile int x = 0;
volatile int y = 0;
// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = 1 ;
}



// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void button2Callback(){
    pressEvent2 = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    button2.mode(PullUp);
    button2.fall(&button2Callback);
   
    while(true){
    if(x==0){
    led1=!led1;
    }
    else if (y==0){
        led=!led;    
        }
        // Toggle the LED every time the button is pressed
        if (pressEvent) {
            x=!x;
            if (x==1){
            led1 = !led1;
            }
            
            pressEvent = 0 ; // Clear the event variable
         }
     
        else if(pressEvent2) {
            y=!y;
            if (y==1){
            led = !led;
            }
            pressEvent2 = 0 ; // Clear the event variable
        }
        Thread::wait(500);
    }
}
