/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftSsd2119.h"
#include "DmTouch.h"

#include "DmDrawBmpBase.h"
#include "SDFileSystem.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
//#define log(...) printf(__VA_ARGS__)
#define log(...)

#define DM_PIN_SPI_MOSI   A0
#define DM_PIN_SPI_MISO   D9
#define DM_PIN_SPI_SCLK   A1

#define DM_PIN_SD_SPI_MOSI   D11
#define DM_PIN_SD_SPI_MISO   D12
#define DM_PIN_SD_SPI_SCLK   D13

#define DM_PIN_CS_TOUCH   D8
#define DM_PIN_CS_TFT     A3
#define DM_PIN_CS_SDCARD  D10

/******************************************************************************
 * Local variables
 *****************************************************************************/

//DmTftHX8353C tft;  /* DM_TFT18_101 */
DmTftS6D0164 tft;  /* DM_TFT22_102 */
//DmTftIli9325 tft;  /* DM_TFT28_103 and DM_TFT24_104 */

SDFileSystem sd(DM_PIN_SD_SPI_MOSI, DM_PIN_SD_SPI_MISO, DM_PIN_SD_SPI_SCLK, DM_PIN_CS_SDCARD, "sd"); // mosi,miso,clk,cs

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);


/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Local functions
 *****************************************************************************/

static bool sdcardReader(uint32_t userData, uint8_t* data, int offset, int numBytes) {
  FILE* fp = (FILE*)userData;
  fseek(fp, offset, SEEK_SET);
  fread(data, 1, numBytes, fp);
  return true;
}

/******************************************************************************
 * Main
 *****************************************************************************/

int main() {
  DmDrawBmpBase bmp;
  const char* fname = "/sd/logop565.bmp";

  log("init tft \r\n");
  tft.init();
  
  while (true) {
    log("Drawing from SD card (%s) ...\n", fname);
    FILE *fp = fopen(fname, "r");
    if (fp != NULL) {
      bmp.drawBitmap(tft, 0, 0, sdcardReader, (uint32_t)fp);
      fclose(fp);
    } else {
      log("failed to open file\n");
      log("Skipping SDCard reading as it is unsupported\n");
      tft.drawStringCentered(0, 0, tft.width(), tft.height(), "SD Card Unsupported!");
    }

    wait_ms(3000);
    tft.clearScreen(RED);
    wait_ms(1000);
  }
}
