/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

#ifndef DM_DRAW_BMP_BASE_h
#define DM_DRAW_BMP_BASE_h

#include "dm_platform.h"
#include "DmTftBase.h"


typedef bool (*readFunc)(uint32_t userData, uint8_t* data, int offset, int numBytes);

class DmDrawBmpBase {
public:
  bool drawBitmap(DmTftBase& tft, uint16_t x, uint16_t y, readFunc func, uint32_t userData=0);
protected:
  bool draw565Bitmap(DmTftBase& tft, uint16_t x, uint16_t y);
  bool draw888Bitmap(DmTftBase& tft, uint16_t x, uint16_t y);
  //virtual void setPosition(uint32_t newPosition) = 0;
  uint16_t read16();
  
  void printBmpHeaderInfo();
  bool readBmpHeader();
  bool IsValid888Bitmap();
  bool IsValid565Bitmap();
  bool Is565ColorMask();
  uint16_t Convert888to565(uint8_t red, uint8_t green, uint8_t blue);

  uint32_t read32();
  int32_t readInt32();
    
  uint32_t _fileSize;
  uint32_t _bitmapOffset;

  uint32_t _headerSize;
  int32_t _width, _height;
  uint16_t _bitsPerPixel;
  uint32_t _compression;
  uint32_t _redMask;
  uint32_t _greenMask;
  uint32_t _blueMask;
  
  readFunc _readFunc;
  uint32_t _userData;
  uint32_t _readPos;
};
#endif

