/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"
#include "DmTouch.h"
#include "DmTouchCalibration.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
//#define log(...) printf(__VA_ARGS__)
#define log(...)

#if 1
  /* Displays without adapter */
  #define DM_PIN_SPI_MOSI   D11
  #define DM_PIN_SPI_MISO   D12
  #define DM_PIN_SPI_SCLK   D13
  #define DM_PIN_CS_TOUCH   D4
  #define DM_PIN_CS_TFT     D10
  #define DM_PIN_CS_SDCARD  D8
  #define DM_PIN_CS_FLASH   D6
#else
  /* Displays with adapter */
  #define DM_PIN_SPI_MOSI   A0
  #define DM_PIN_SPI_MISO   D9
  #define DM_PIN_SPI_SCLK   A1
  #define DM_PIN_CS_TOUCH   D8
  #define DM_PIN_CS_TFT     A3
  #define DM_PIN_CS_SDCARD  D10
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/

//DmTftIli9325 tft;  /* DM_TFT28_103 and DM_TFT24_104 */
//DmTftIli9341 tft;  /* DM_TFT28_105 */
//DmTftSsd2119 tft;   /* DM_TFT35_107 */
DmTftRa8875  tft;  /* DM_TFT43_108 and DM_TFT50_111 */  

//DmTouch touch(DmTouch::DM_TFT28_103, DmTouch::Software); /* For LPC4088 QuickStart Board */
//DmTouch touch(DmTouch::DM_TFT28_103);
//DmTouch touch(DmTouch::DM_TFT24_104, DmTouch::Software); /* For LPC4088 QuickStart Board */
//DmTouch touch(DmTouch::DM_TFT24_104);
//DmTouch touch(DmTouch::DM_TFT28_105);
//DmTouch touch(DmTouch::DM_TFT35_107);
//DmTouch touch(DmTouch::DM_TFT43_108);  // For DmTftRa8875 driver, The panel resolution should be config in DmTftRa8875::init() function on the DmTftRa8875.cpp file.
DmTouch touch(DmTouch::DM_TFT50_111);

DmTouchCalibration calibration = DmTouchCalibration(&tft, &touch); 

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
  DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif

bool calibrated = false;

/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Local functions
 *****************************************************************************/

static void loop() {
  uint16_t x, y = 0;
  bool touched = false;
  
  if (!calibrated) {
    tft.drawString(5, 5, "Press and hold on cross");
    tft.drawString(5, 25, "until it turns green. ");

    Point displayRefPoint[5];
    Point touchRefPoint[5];
    if (calibration.getTouchReferencePoints(displayRefPoint, touchRefPoint, tft.width(), tft.height())) {
      CalibrationMatrix calibrationMatrix = calibration.calculateCalibrationMatrix(displayRefPoint, touchRefPoint);
      touch.setCalibrationMatrix(calibrationMatrix);
      tft.clearScreen();
      calibration.drawCalibPoint(displayRefPoint[0].x, displayRefPoint[0].y); 
      calibration.drawCalibPoint(displayRefPoint[1].x, displayRefPoint[1].y); 
      calibration.drawCalibPoint(displayRefPoint[2].x, displayRefPoint[2].y); 
      calibration.drawCalibPoint(displayRefPoint[3].x, displayRefPoint[3].y); 
      calibration.drawCalibPoint(displayRefPoint[4].x, displayRefPoint[4].y);
      calibration.drawCalibration(calibrationMatrix);
      calibrated = true;
    } else {
      tft.clearScreen();
      tft.drawString(5, 5, "Calibration failed");
      tft.drawString(5, 25, "Please try again.");
      delay(2000);
      tft.clearScreen();
      return;
    }
  }
  
  if (touch.isTouched()) {
    touch.readTouchData(x,y,touched);
    calibration.drawCalibPoint(x, y);
  }
} 

/******************************************************************************
 * Main
 *****************************************************************************/

int main() {
  tft.init();
  touch.init();
  while (1) {
    loop();
  }
}

