#ifndef API_DATATYPES_H
#define API_DATATYPES_H
/** @file api_datatypes.h
* @brief Data structures that the API uses for responses and commands. */

/** Data structure returned from Get Info command. */
typedef struct {
 uint16_t major; ///< Major version (e.g. 1)
 uint16_t minor; ///< Minor version (e.g. 3)
 uint16_t patch; ///< Patch version (e.g. 2)
 uint16_t build; ///< Build number (e.g. 122)
 uint16_t ll_version; ///< Link Layer Version
 uint8_t protocol_version; ///< BGAPI Version
 uint8_t hw; ///< Hardware Version
} ble_msg_system_get_info_rsp_t;


/** Data structure passed into the Reset command. */
typedef struct {
    uint8_t boot_in_dfu; ///< Determine whether or not to boot into Device Firmware Update (DFU) mode. 1 for booting into DFU, 0 otherwise.
} ble_msg_system_reset_t;

/** Data structure returned from Boot event. */
typedef struct {
 uint16_t major; ///< Major version (e.g. 1)
 uint16_t minor; ///< Minor version (e.g. 3)
 uint16_t patch; ///< Patch version (e.g. 2)
 uint16_t build; ///< Build number (e.g. 122)
 uint16_t ll_version; ///< Link Layer Version
 uint8_t protocol_version; ///< BGAPI Version
 uint8_t hw; ///< Hardware Version
} ble_msg_system_boot_evt_t;

/** Data structure returned from Discover command. */
typedef struct {
    uint16_t result; ///< Result. Non-zero value indicates an error.
} ble_msg_gap_discover_rsp_t;



/** Data structure representing a scan result */
typedef struct {
    int8_t rssi; ///< RSSI value (dBm).
    uint8_t packet_type; ///< Scan response header. 
    uint8_t hw_addr[6]; ///< BLE Hardware Address.
    uint8_t address_type; ///< Address type. 1 for random, 0 for public.
    uint8_t bond; ///< Bond handle if known bond for device, 0xff otherwise.
    uint8_t *data; ///< Service data.
    uint8_t data_len; ///< Service data length (in bytes).
} ble_msg_gap_scan_result_evt_t;

#endif