#include "api_datatypes.h"
#ifndef CALLBACKS_H
#define CALLBACKS_H

/** @file callbacks.h 
* @brief Definitions of function callbacks that BGLib will invoke.
* In order to take advantage of these callbacks, use the corresponding setter in the BGLib API.
*/

/** @brief Function pointer for Hello response handler. 
* This is a pointer to a callback for the Hello response. It should point to a function that takes no arguments.
*/
typedef void (*hello_callback_t)();

/** Function pointer for Get Info response handler. 
* @param ble_msg_system_get_info_rsp_t A data structure containing the response. 
*/
typedef void (*get_info_callback_t)(ble_msg_system_get_info_rsp_t);

/** Function pointer for System Boot event handler. 
* @param ble_msg_system_boot_evt_t A data structure containing the data from the System Boot event.
*/
typedef void (*boot_callback_t)(ble_msg_system_boot_evt_t);

/** Function pointer for timestamping. This is a function that is intended to run whenever there is <em>any</em> data available on the UART.
*/
typedef void (*timestamp_callback_t)();

/** Function pointer for Discover response handler.
* @param ble_msg_gap_discover_rsp_t A data structure containing the response.
*/
typedef void (*discover_callback_t)(ble_msg_gap_discover_rsp_t);

/** Function pointer for Scan Result event handler.
* @param ble_msg_gap_scan_result_evt_t A data structure containing the data from a Scan Result event.
*/
typedef void (*scan_result_callback_t)(ble_msg_gap_scan_result_evt_t);

#endif