#include "mbed.h"

#include "EthernetNetIf.h"
#include "HTTPServer.h"

// mDNS response to announce oneselve
#include "services/mDNS/mDNSResponder.h"

DigitalOut myled(LED1);
EthernetNetIf eth;
HTTPServer srv;
mDNSResponder mdns; // make sure LWIP_IGMP is set in netCfg.h !

int main() {
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup on DHCP.\r\n", ethErr);
        return -1;
    }
    srv.addHandler<SimpleHandler>("/"); // Something.
    srv.addHandler<SimpleHandler>("/sample"); // Something too
    srv.bind(80);
        
    IpAddr ip = eth.getIp();
    printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

    // Announce above web server - and keep doing that every minute or so.
    //
    mdns.announce(
        ip,                         // (My) IP address - where announced service runs.
        "propername",               // DNS name server or service
        "_http._tcp",               // protocol
        80,                         // Port number
        "May the blood run free",   // User interface name service
        (char *[]) {                // NULL terminated list of KV's = see                                     // http://www.zeroconf.org/Rendezvous/txtrecords.html
            "path=/sample",         // http://www.zeroconf.org/Rendezvous/txtrecords.html
//          "key2=someval", 
//          "and=more",
            NULL
        }
    );
    
    // So that clicking on 'May the blood run free' will jump to:
    //
    //   http://propername.local.:80/sample (or http://propername/sample in the bar)

    printf("Entering while loop Net::poll()ing\r\n");
    while (1) {
        Net::poll();
    }
}
