
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef USB_ENDPOINT_H
#define USB_ENDPOINT_H

#include "mbed.h"
#include "USBHostLite/usbhost_inc.h"

typedef int32_t RC;

class EdPool
{
public:
  EdPool(int size);
  ~EdPool();
  HCED* get();
private:
  uint8_t* m_pool;
  int m_pos;

};

class TdPool
{
public:
  TdPool(int size);
  ~TdPool();
  HCTD* get();
private:
  uint8_t* m_pool;
  int m_pos;

};

class UsbEndpoint
{
public:
  UsbEndpoint( /* UsbDevice*, */ uint8_t ep, bool dir, uint16_t size );
  ~UsbEndpoint();

  RC transfer(volatile uint8_t* buf, uint32_t len); 
  
  RC status(); 
  
//static void completed(){}

private:
  EdPool m_edPool;
  TdPool m_tdPool;
  
  bool m_dir;
  
  bool m_done;
  
  uint32_t m_len;
  
  volatile uint8_t* m_pBufStartPtr;

  volatile HCED* m_pEd; //Ep descriptor
  volatile HCTD* m_pTdHead; //Head trf descriptor
  volatile HCTD* m_pTdTail; //Tail trf descriptor
  
  //static volatile HCED* m_pNextEd;
  
};

#endif
