
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*
  USB-Serial device driver
  Donatien Garnier 2010
*/

#ifndef  USBSERIALIF_H
#define  USBSERIALIF_H

/*
**************************************************************************************************************
*                                       INCLUDE HEADER FILES
**************************************************************************************************************
*/

#include  "drv/usb/USBHostLite/usbhost_inc.h"

/*
**************************************************************************************************************
*                                     FUNCTION PROTOTYPES
**************************************************************************************************************
*/

USB_INT32S SerialRx( volatile USB_INT08U* buf, USB_INT32U len );
USB_INT32S SerialReceived();

USB_INT32S SerialTx( volatile USB_INT08U* buf, USB_INT32U len );
USB_INT32S SerialTransmitted();

USB_INT32S SerialCheckVidPid();
USB_INT32S SerialParseConfig();

USB_INT32S SerialInit();


bool SerialHasToSwitch();
USB_INT32S SerialSendMagic();

USB_INT32S SerialReg(USB_INT16U vid, USB_INT16U pid);

#endif
