#include "RestMeterHandler.h"

RestMeterHandler::RestMeterHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket) {
}

RestMeterHandler::~RestMeterHandler() {
}

const char *(*RestMeterHandler::callback)(const char*) = NULL;

void RestMeterHandler::attach(const char *(*cb)(const char * command)) {
    callback = cb;
}

void RestMeterHandler::doGet() {
    const char * p = path().c_str();
    const char * q = strstr(p,"cmd=");

    if (q && q[4]) 
    {
        q+=4;
    } else {
        q = "none";
    };

    const char * resp = "No callback";

    printf("Calling back with %s, cb=%p\n\r", q,callback);

    if (callback)
        resp = (*callback)(q);

    setContentLen( strlen(resp) );
    respHeaders()["Connection"] = "close";
    writeData(resp, strlen(resp));
}

void RestMeterHandler::doPost() {
}

void RestMeterHandler::doHead() {
}

void RestMeterHandler::onReadable() { //Data has been read
}

void RestMeterHandler::onWriteable() { //Data has been written & buf is free
    close(); //Data written, we can close the connection
}

void RestMeterHandler::onClose() { //Connection is closing
    //Nothing to do
}
