#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
 
SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk
DigitalOut cs(PTD0);

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

unsigned char c, a, m;
unsigned char dato;
 
int main() 
{
    // Chip must be deselected
    cs = 1;
    
    // Setup the spi for 8 bit data
    spi.format(8,1);            //CPOL=0 , CPHA=1 ---> al fronte di salita inizia il bit
    spi.frequency(800000);     // 1 MHz
    led_red = 1;
    led_green = 1;
    pc.baud(115200);
    
    while(1)
    {
        pc.printf("\nPremi 0 per scrittura o 1 per lettura: ");
                    m = pc.getc();
        switch(m)
        {
            case '0':   pc.printf("\nInserisci il dato: ");
                        c = pc.getc();
                        pc.printf("\nInserisci l'indirizzo: ");
                        a = pc.getc();
                        
                        // write RAM
                        cs = 0;
                        spi.write('#');
                        spi.write(0x06);
                        spi.write(a); //address MSB
                        spi.write(0x01);
                        spi.write(0x01); // address LSB
                        spi.write('#'); 
                        spi.write(c); 
                        while(spi.write(0x55) != '@'); 
                        pc.printf("\n%c scritto all'indirizzo %c.", c, a);
                        cs = 1;
                        wait(0.01);
                        break;
        
            case '1':   pc.printf("\nInserisci l'indirizzo: ");
                        a = pc.getc();
                        // read RAM
                        cs = 0;
                        spi.write('#');
                        spi.write(0x04);
                        spi.write(a); //address MSB
                        spi.write(0x01);
                        spi.write(0x01); // address LSB
                        while(spi.write(0x55) != '@');// come sopra
                        dato = spi.write(0x55);
                        pc.printf("\nDato letto da RAM all'indirizzo %c: %c", a, dato );
                        dato = spi.write(0x55);
                        pc.printf("%c", dato);
                        cs = 1; 
                        wait(0.01);
            
            default:    pc.printf("\nComando errato.");
                        break;
        }
    }   
}