#include "mbed.h"

//====================== Definição os pinos ==================

InterruptIn botao_D(D8);
InterruptIn botao_EN(D9);
DigitalIn botao_P(D10);
DigitalOut simula_passos(D11);

//============ Declaração dos timers para debouce ============
Timer debouce_D;
Timer debouce_EN;
//////////////////////////////////////////////////////////////

BusOut motor(PB_1, PB_15, PB_14, PB_13); //Função BusOut para o acionamento das fases do motor

int i, P; //Declaro o incremento "i" e a variável para leitura do botao_P

float tempo = 0.003; //Tempo padrão entre o acionamento das fases

//======== Declaração das booleanas ==========================

bool inverte_direcao = false;
bool habilita_passos = false;

//======== Declaração das funções ============================

void rotina_horario(void);
void rotina_anti_horario(void);
void rotina_botao_D(void);
void rotina_botao_EN(void);
void rotina_botao_P(void);


int main()
{
    motor = 0x00; //Estado inicial do motor

    debouce_D.start(); //Inicialização do timer
    debouce_EN.start(); //Inicialização do timer

    botao_D.rise(&rotina_botao_D); //Define o método de detecção
    botao_EN.rise(&rotina_botao_EN); //Define o método de detecção

    while(1) {

        P = botao_P.read(); //Leitura do botão P

//=============== Lógica descrita no fluxograma ===========

        if(inverte_direcao == false) {
            rotina_horario();
        }

        else {
            rotina_anti_horario();
        }
        if(P == 1) {
            simula_passos = 1;
            wait(tempo);
            simula_passos = 0;
            wait(tempo);
        }
//=========================================================      
    }
}

void rotina_horario()
{

    if(habilita_passos == false) {
        for(i = 0; i < 4; i++) {
            motor = 1 << i;
            wait(tempo);
        }
    } else {
        motor = 0x00;
    }

}

void rotina_anti_horario()
{
    if(habilita_passos == false) {
        for(i = 3; i > -1; i--) {
            motor = 1 << i;
            wait(tempo);
        }
    } else {
        motor = 0x00;
    }

}

void rotina_botao_D()
{
    if(debouce_D.read_ms() >= 5) {

        inverte_direcao =! inverte_direcao;
        debouce_D.reset();
    }
}

void rotina_botao_EN()
{
    if(debouce_EN.read_ms() >= 5) {

        habilita_passos =! habilita_passos;
        debouce_EN.reset();
    }
}


