#include "mbed.h"
#include "USBSerial.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "SHT3XA.h"
#include "rtos.h"

I2C i2c(PB_9,PB_8);
SHT3XA sht31a(PA_4);
int Acel_Buffer[4];
float Acel_value=0;
int ddx = 1;
char ccc;

USBSerial usb_serial;
DigitalOut led(LED3);
DigitalOut led2(LED4);

Thread thread;

//GPS_Coordenates[80];
// addr
#define WRITE_ADDR 0x52
#define READ_ADDR 0x53
//   LIS3DH ID
#define I_AM_LIS3DH         0x33

//  Register's definition
#define LIS3DH_STATUS_REG_AUX  0x07
#define LIS3DH_OUT_ADC1_L      0x08
#define LIS3DH_OUT_ADC1_H      0x09
#define LIS3DH_OUT_ADC2_L      0x0a
#define LIS3DH_OUT_ADC2_H      0x0b
#define LIS3DH_OUT_ADC3_L      0x0c
#define LIS3DH_OUT_ADC3_H      0x0d
#define LIS3DH_INT_COUNTER_REG 0x0e
#define LIS3DH_WHO_AM_I        0x0f
#define LIS3DH_TEMP_CFG_REG    0x1f
#define LIS3DH_CTRL_REG1       0x20
#define LIS3DH_CTRL_REG2       0x21
#define LIS3DH_CTRL_REG3       0x22
#define LIS3DH_CTRL_REG4       0x23
#define LIS3DH_CTRL_REG5       0x24
#define LIS3DH_CTRL_REG6       0x25
#define LIS3DH_REFERENCE       0x26
#define LIS3DH_STATUS_REG2     0x27
#define LIS3DH_OUT_X_H         0x29
#define LIS3DH_OUT_Y_H         0x2b
#define LIS3DH_OUT_Z_H         0x2d
#define LIS3DH_FIFO_CTRL_REG   0x2e
#define LIS3DH_FIFO_SRC_REG    0x2f
#define LIS3DH_INT1_CFG        0x30
#define LIS3DH_INT1_SOURCE     0x31
#define LIS3DH_INT1_THS        0x32
#define LIS3DH_INT1_DURATION   0x33
#define LIS3DH_CLICK_CFG       0x38
#define LIS3DH_CLICK_SRC       0x39
#define LIS3DH_CLICK_THS       0x3a
#define LIS3DH_TIME_LIMIT      0x3b
#define LIS3DH_TIME_LATENCY    0x3c
#define LIS3DH_TIME_WINDOW     0x3d

// definition for Nomalization
#define LIS3DH_SENSITIVITY_2G  (0.001F)
#define LIS3DH_SENSITIVITY_4G  (0.002F)
#define LIS3DH_SENSITIVITY_8G  (0.004F)
#define LIS3DH_SENSITIVITY_16G (0.012F)


#define GRAVITY (9.80665F)

void main_thread(){
    char dbf[2],addr,data[6];
    float dt[3],acc[2][3],a,b,c,d;
    int xx=0;
    addr = WRITE_ADDR;
    dbf[0] = LIS3DH_WHO_AM_I;
    i2c.write(addr, dbf, 1);
    i2c.read(addr | 1, dbf, 1);
    led2=1;
    if(dbf[0] == I_AM_LIS3DH) {
       
        //
        while(1){
        for(int i=0; i<12;i++) {
            
            dbf[0] = LIS3DH_CTRL_REG1;
            dbf[1] = 0x27; //ORIGINAL 0x7f
            i2c.write(addr , dbf , 2);
//======================================================//
            dbf[0] = LIS3DH_OUT_X_H | 0x80;
            //dbf[1] = 0xff; 
            i2c.write(addr, dbf, 1);
            
            dbf[0] = LIS3DH_OUT_Y_H | 0x80;
            i2c.write(addr, dbf, 1);
            
            dbf[0] = LIS3DH_OUT_Z_H | 0x80;
            i2c.write(addr, dbf, 1);
            
            i2c.read(addr | 1, data, 6);
            dt[0] = float(short((data[1]<<8) | data[0])) *LIS3DH_SENSITIVITY_16G  / 15 * GRAVITY;
            dt[1] = float(short((data[3]<<8) | data[2])) *LIS3DH_SENSITIVITY_16G  / 15 * GRAVITY;
            dt[2] = float(short((data[5]<<8) | data[4])) *LIS3DH_SENSITIVITY_16G  / 15 * GRAVITY;
            
            acc[xx][0] = dt[0];
            acc[xx][1] = dt[1];
            acc[xx][2] = dt[2];
            if (xx == 0){
                xx=1;
                }
            else{
                xx =0;
                }
            a = (acc[1][0]-acc[0][0])*(acc[1][0]-acc[0][0]);
            b = (acc[1][1]-acc[0][1])*(acc[1][1]-acc[0][1]);
            c = (acc[1][2]-acc[0][2])*(acc[1][2]-acc[0][2]);
            d = sqrt(a+b+c);
            wait(5);
            //usb_serial.printf("x -> %f y -> %f z -> %f\r\n",dt[0],dt[1],dt[2]);
            usb_serial.printf("Acelaration -> %f\r\n",d);
            
            if (d < 0.5){
                Acel_value++;
                }
            else{
                Acel_value = 0;
                
                }
                
            if (Acel_value == 4){
                    while(1){
                    led2=0;
                    wait(0.5);
                    led2 = 1;
                    }
                }
            
            led = 0;
            wait(0.5);
            led = 1;
            wait(5);
            
            usb_serial.printf("Temperature -> %f\r\n",sht31a.readTempC());
            if (sht31a.readTempC() > 35){
                while(1){
                    led2=0;
                    wait(0.5);
                    led2 = 1;
                    }
                }
            
            led = 0;
            wait(0.5);
            led = 1;


        }
    }
   } 
    
    }



int main() {
    
  thread.start(main_thread);   
    
}
