
#ifndef _MQTTNETWORK_H_
#define _MQTTNETWORK_H_
 

#include "EthernetInterface.h"

class MQTTNetwork {
public:
    MQTTNetwork(NetworkInterface* aNetwork) : network(aNetwork) {
        socket = new TCPSocket();
    }
 
    ~MQTTNetwork() {
        delete socket;
    }
 
    int read(unsigned char* buffer, int len, int timeout) {
        return socket->recv(buffer, len);
    }
 
    int write(unsigned char* buffer, int len, int timeout) {
        return socket->send(buffer, len);
    }
 
    int connect(const char* hostname, int port) {
        /*
        socket->open(network);
        return socket->connect(hostname, port);
        */
         socket->open(network);
        network->gethostbyname(hostname,&a);
        a.set_port(port);
        return socket->connect(a);
    }
 
    int disconnect() {
        return socket->close();
    }
 
private:
    NetworkInterface* network;
    TCPSocket* socket;
    SocketAddress a;
};


#endif // _MQTTNETWORK_H_