#include "mbed.h"
#include "Pulse.h"
#include "SDFileSystem.h"
 
//SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); // the pinout on the mbed Cool Components workshop board
SDFileSystem sd(p5, p6, p7, p26, "sd");

AnalogIn sense(p15);
PulseInOut pulse1(p8);
DigitalOut output1(LED1);
Serial pc(USBTX, USBRX);


//pc.baud(9600);
//Serial async_port(PTA2,PTA1);

unsigned long duration;
unsigned long starttime;
unsigned long sampletime_ms = 30000;//sampe 30s ;
unsigned long lowpulseoccupancy = 0;
float ratio = 0;
float concentration = 0;

Timer t1; // define timer object
void task1(void); // task function prototype

int main() 
 {
      mkdir("/sd/mydir", 0777);
 t1.start(); // start timer counting
 starttime=t1.read_ms();
  while(1) {
    duration=pulse1.read_low_us();
    lowpulseoccupancy = lowpulseoccupancy+duration;
if ((t1.read_ms()-starttime) > sampletime_ms) // read time in ms
 {
     pc.printf("Sensor value: %f \n\r", sense.read());
     pc.printf("Before Task\n\r");
     pc.printf("\n Duration=%lu,Low Pulse Occupancy=%lu,starttime=%lu\n\r",duration,lowpulseoccupancy,starttime);
 task1(); // call task function
     FILE *fp = fopen("/sd/mydir/sdtest.txt", "a+");
        if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Sensor value:%f,Low Pulse Occupancy=%lu,Time: %lu",sense.read(),lowpulseoccupancy,starttime);
    //pc.printf("\n Sensor value:%f",sense.read());
    fclose(fp); 
    lowpulseoccupancy = 0;

 }
 }
}
void task1(void)
{ 
    ratio = lowpulseoccupancy/(sampletime_ms*10.0);  // Integer percentage 0=>100
    concentration = 1.1*pow(ratio,3)-3.8*pow(ratio,2)+520*ratio+0.62; // using spec sheet curve
    pc.printf("After Task\n\r");
    pc.printf("\n Low pulse occupancy=%lu",lowpulseoccupancy);
    pc.printf(",");
    pc.printf("Ratio=%f",ratio);
    pc.printf(",");
    pc.printf("Concentration=%f\n\r",concentration);
    
    starttime = t1.read_ms();
    output1=!output1; // toggle output
    
}