#include <stdio.h>
#include "mbed.h"
#include "BMP180.h"
 
I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(USBTX,USBRX);
BMP180 bmp180(&i2c);
 
int main(void) {
 
    while(1) {
        if (bmp180.init() != 0) {
            pc.printf("NO SE PUDO COMUNICAR\n");
        } else {
            pc.printf("BMP180 FUNCIONO\n");
            break;
        }
        wait(1);
    }
 
    while(1) {
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete
        float temp;
        if(bmp180.getTemperature(&temp) != 0) {
            pc.printf("NO SE PUDO LEER LA TEMP\n");
            continue;
        }
 
        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        int pressure;
        if(bmp180.getPressure(&pressure) != 0) {
            pc.printf("Error Leyendo la presion\n");
            continue;
        }
 
        pc.printf("Presion = %d Pa Temperatura = %f C\n\r", pressure, temp);
        wait(1);
    }
}
