/* mbed PCF8574 Library, for driving the I2C I/O Expander
 * Copyright (c) 2008-2010, cstyles, sford (Originally PCF8574 lib)
 *                          new created by Lerche
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "PCF8575.h"
#include "mbed.h"

PCF8575::PCF8575(PinName sda, PinName scl, int address)
        : _i2c(sda, scl) {
    _address = address;
}

int PCF8575::read() {
    char foo[2];
    _i2c.read(_address, foo, 2);
    
    return (foo[1] << 8) | foo[0];
}

void PCF8575::write(int data) {
    char foo[2];
    foo[0]=data;
    foo[1]=data>>8;
    _i2c.write(_address, foo, 2);
}
