
#include "EthernetInterface.h"
#include "mbed.h"
#include "nsapi_types.h"

// Network interface
EthernetInterface eth;

void status_callback(nsapi_event_t status, intptr_t param)
{
    printf("Connection status changed!\r\n");
    switch(param) {
        case NSAPI_STATUS_LOCAL_UP:
            printf("Local IP address set!\r\n");
            break;
        case NSAPI_STATUS_GLOBAL_UP:
            printf("Global IP address set!\r\n");
            break;
        case NSAPI_STATUS_DISCONNECTED:
            printf("No connection to network!\r\n");
            break;
        case NSAPI_STATUS_CONNECTING:
            printf("Connecting to network!\r\n");
            break;
        default:
            printf("Not supported");
            break;
    }
}
void onemorethread(void)
{
    while (1)
    {
     //   Thread::wait(10);   
    }    
}

int main()
{
    printf("Connecting...\n");
    eth.attach(&status_callback);
    eth.set_network("192.168.1.200","255.255.255.0","192.168.1.1");
    eth.connect();
    Thread onemore;
    onemore.start(onemorethread);
    while(1)
    {
        Thread::wait(10);
    }
 }