#if defined(TARGET_NUCLEO_F767ZI)


#define MODSERIAL_IRQ_REG ((USART_TypeDef*)_base)->CR1  //found in mbed-dev\targets\TARGET_STM\TARGET_STM32F7\TARGET_STM32F746xG\device\stm32f746xx.h
#define DISABLE_TX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_TXEIE
#define DISABLE_RX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_RXNEIE
#define ENABLE_TX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_TXEIE
#define ENABLE_RX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_RXNEIE

#define MODSERIAL_READ_REG ((USART_TypeDef*)_base)->RDR
#define MODSERIAL_WRITE_REG ((USART_TypeDef*)_base)->TDR
#define MODSERIAL_READABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_RXNE) != 0)
#define MODSERIAL_WRITABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_TXE) != 0)

#define RESET_TX_FIFO while(0 == 1)
#define RESET_RX_FIFO while(MODSERIAL_READABLE) char dummy = MODSERIAL_READ_REG

#define RX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_RXNEIE) != 0)
#define TX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_TXEIE) != 0)
#endif
