Ticker rt_ticker;
bool realtime_flag;


void balance_coord(){
    float delta_x = (target.x - current.x); if (delta_x == 0) delta_x = 0.0001;
    float delta_y = (target.y - current.y);
    float delta_s = sqrt(delta_x*delta_x + delta_y*delta_y); //always positive        //if (delta_x < 0) {delta_s = -delta_s;}
    float azimuth_to_target = atan(delta_y/delta_x); if (delta_x < 0){if (delta_y > 0) azimuth_to_target += pi; else azimuth_to_target -= pi;}
    
    float delta_phi_0 = azimuth_to_target - current.azimuth;                                                                                                    //azimuth: target error
    if (delta_phi_0 < -pi) delta_phi_0 += 2*pi; if (delta_phi_0 > pi) delta_phi_0 -= 2*pi;
    
    float normal_error  = delta_s * sin(delta_phi_0);
    float tan_error = delta_s * cos(delta_phi_0);
    
    float a = x_prop * tan_error - x_diff * current.speed;                                                                                                      //Motion PID
    if ((current.speed > max.speed) && (a > 0)) a = max.accel * (2 - current.speed/max.speed); if ((current.speed < -max.speed) && (a < 0)) a = -max.accel * (2 + current.speed/max.speed); 
    if (a > max.accel) a = max.accel ; if (a < -max.accel) a = -max.accel;

    float delta_v = (balance_prop*ax + balance_diff * gy + a) * t_step;                                                                                         //Balance PID
       
    float delta_phi_1 = (target.azimuth - current.azimuth);//* (current.speed * t_step / delta_s);                                                              //azimuth: sever error
    if (delta_phi_1 < -pi) delta_phi_1 += 2*pi; if (delta_phi_1 > pi) delta_phi_1 -= 2*pi;
    if (delta_phi_1 < -pi/2) delta_phi_1 = -pi/2; if (delta_phi_1 > pi/2) delta_phi_1 = pi/2;

    if (delta_phi_0 < -pi/2) delta_phi_0 += pi; if (delta_phi_0 > pi/2) delta_phi_0 -= pi;    //Normalization [-pi/2; pi/2] - (zadom/peredom)
//    float delta_phi = cos(delta_s/coord_accuracy) * coord_accuracy/(delta_s + coord_accuracy) * 1.0 * delta_phi_1 + abs(tan_error) /*delta_s*/ /(delta_s + coord_accuracy) * delta_phi_0;   
    float delta_phi = cos(delta_s/coord_accuracy) * exp(-delta_s/coord_accuracy) * delta_phi_1 + (1-exp(-delta_s/coord_accuracy)) * abs(tan_error) /(coord_accuracy) * delta_phi_0;  //fusion of delta_phi_0 and delta_phi_1 + uprezhdenie 
    if (delta_phi > pi/2) delta_phi -= pi; if (delta_phi < -pi/2) delta_phi += pi;    

    float eps = azimuth_prop * delta_phi - azimuth_diff * current.omega; if (eps > max.eps) eps = max.eps; if (eps < -max.eps) eps = -max.eps;                  //Azimuth PID
    float delta_omega = eps * t_step;
    
    //wifi.printf("%.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f;\r\n",current.x*100, current.y*100, current.azimuth, target.x*100, azimuth_to_target, eps, delta_omega, delta_phi_0, delta_phi_1, delta_phi); 
    
    set_motor_speed(motor_speed[0] - delta_v + delta_omega * half_axis, motor_speed[1] - delta_v - delta_omega * half_axis);                                    //Set motor
    
    if ((abs(normal_error) < coord_accuracy) && (abs(tan_error) < coord_accuracy/2) && (abs(target.azimuth - current.azimuth) < 0.1))  coord_ready = 1; else coord_ready = 0;
}

void balance_motion(){
    
    int sign_da; //signum of da
    int sign_de; //eps
    switch(motion_mode){
        case GO:{
            sign_de = 0;
            if ((abs(theor.path) < max.speed*max.speed/max.accel) || (abs(target.path - theor.path) < max.speed*max.speed/max.accel)){
                //if (abs(theor.speed) < max.speed/2) sign_da = 1; else sign_da = -1;}   //Razgon/Tormoz
                if (abs(theor.path) < max.speed*max.speed/max.accel/6) sign_da = 1; else sign_da = -1; }
            else sign_da = 0; //ezda       
            if (target.dir == 0) sign_da = -sign_da;
            
            theor.speed += (theor.accel + sign_da * da) * t_step; //for next step
            theor.path += theor.speed * t_step; 
            if (((target.path < theor.path) && (target.dir == 1)) || ((target.path > theor.path) && (target.dir == 0))) {coord_ready = 1;sign_da = 0;} 
            else coord_ready = 0;
            break;}
        case STOP:{
            //float tma = x_prop * (target.path - current.path) - x_diff * current.speed;                                                                                                      //Motion PID
            sign_da = 0;//tma/da;  
            sign_de = 0;
            theor.speed = 0;
            theor.accel = 0;
            break;
            }
        case ROTATE:{
            sign_da = 0;
            float tm_az = target.azimuth - current.azimuth; if (tm_az < - pi) tm_az += 2*pi; if (tm_az > pi) tm_az -= 2*pi;
            if (tm_az < delta.azimuth/2) sign_de = -1; else sign_de = 1;
            if (abs(tm_az) < 0.1) {coord_ready = 1;sign_de = 0;
                motor_speed[0] = (motor_speed[0] + motor_speed[1])/2;
                motor_speed[1] = motor_speed[0];
            } 
            else coord_ready = 0;
            break;
            }
        }
    theor.accel += sign_da * da;
     //wifi.printf("%d, %f\r\n",sign_da,da);
    balance_integral += ax;
    float delta_v = (balance_prop*ax + balance_diff * gy + theor.accel) * t_step;         //Balance PID
    float delta_omega = max.eps * sign_de * t_step;
    set_motor_speed(motor_speed[0] - delta_v + delta_omega * half_axis, motor_speed[1] - delta_v - delta_omega * half_axis);                                    //Set motor
    wifi.printf("%f, %f, %f, %f %f, %f\r\n",current.path,theor.path,theor.speed,theor.accel,target.path,motor_speed[0]); 
}

void balance_motion_PID(){
    float tma;
    int sign_de; //eps
    float tm_lim;//ogran skorosti (uskor ot skorosti)
        
    x_integral += (target.path - current.path);
    if (abs(current.speed) > 0.05) x_integral = 0;    
    switch(motion_mode){
        case GO:{
            sign_de = 0;
            float path_error = (target.path - current.path); 
            if (abs(path_error) < coord_accuracy) {coord_ready = 1;tma = 0;}
            else {
                //if (path_error > 0.04) path_error = 0.04;  if (path_error < -0.04) path_error = -0.04;

                tma = x_prop * path_error - x_diff * current.speed + x_int * x_integral;
                if (current.speed * tma > 0) tm_lim = max.accel*(max.speed - abs(current.speed))/max.speed; else tm_lim = max.accel; //ogran skor
                tma = atan(tma/tm_lim*pi/2) * tm_lim * 2 / pi;                                                                                                 //Motion PID
                coord_ready = 0;}
            break;}
        case STOP:{
            tma = x_prop * (target.path - current.path) - x_diff * current.speed ;//+ x_int * x_integral; 
            if (current.speed * tma > 0) tm_lim = max.accel*(max.speed - abs(current.speed))/max.speed; else tm_lim = max.accel; //ogran skor
            tma = atan(tma/tm_lim*pi/2) * tm_lim * 2 / pi;  //ogran uskor                                                                                                   //Motion PID
            sign_de = 0;
            break;
            }
        case ROTATE:{
            float tm_az = target.azimuth - current.azimuth; if (tm_az < - pi) tm_az += 2*pi; if (tm_az > pi) tm_az -= 2*pi;
            if (tm_az < delta.azimuth/2) sign_de = -1; else sign_de = 1;
            if (abs(tm_az) < 0.1) {coord_ready = 1;sign_de = 0;
                motor_speed[0] = (motor_speed[0] + motor_speed[1])/2;
                motor_speed[1] = motor_speed[0];
            } 
            else coord_ready = 0;
            break;
            }
        }
     //wifi.printf("%d, %f\r\n",sign_da,da);
    float delta_v = (balance_prop * ax + balance_diff * gy + tma) * t_step;         //Balance PID
    float delta_omega = max.eps * sign_de * t_step;
    set_motor_speed(motor_speed[0] - delta_v + delta_omega * half_axis, motor_speed[1] - delta_v - delta_omega * half_axis);                                    //Set motor
    //wifi.printf("%f, %f, %f, %f %f, %f\r\n",current.path,theor.path,theor.speed,theor.accel,target.path,motor_speed[0]); 
    wifi.printf("%f %f %f %f;",current.speed,tma,ax,gy); 
}



void realtime(){ 
    time_sec += t_step;
    fall_timer++; if(abs(ax)<3) fall_timer=0; if(fall_timer>50) fall_flag=1; else fall_flag=0;     //fall check
    realtime_flag = 1; 
    }

void realtime_init(){
    rt_ticker.attach(&realtime, t_step);    }


  
