/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "DS18B20.h"
#include "TextLCD.h"

I2C i2c_pin(I2C_SDA, I2C_SCL);
Adafruit_SSD1306_I2c oled(i2c_pin, PA_4, 0x78, 64, 128);
TextLCD_I2C lcd(&i2c_pin, 0x4E);
DS18B20 sensor(PA_5); 
// Blinking rate in milliseconds
#define BLINKING_RATE     500ms
int col = 0;

int main() {

  // *********** Oled 128 x 64 *********
  int tickTime = 1000;
  oled.begin(SSD1306_SWITCHCAPVCC);
  HAL_Delay(200);
  oled.splash();
  oled.display();
  HAL_Delay(2000);
  oled.clearDisplay();

  // Initialise the digital pin LED1 as an output
  DigitalOut led(PC_13);
   // ******* LCD 1602 *************
  //lcd.locate(0, 0); //    Position initial
  lcd.setCursor(TextLCD::CurOff_BlkOff);
  lcd.cls();
  lcd.setBacklight(TextLCD::LightOn);
  lcd.printf(" Sonde thermale\n");

  while (true) {
    oled.clearDisplay();
    float temperature = sensor.readTemp();
    led = !led;
    ThisThread::sleep_for(BLINKING_RATE);
     // ***** LCD 1602 ***
    lcd.locate(0, 1);
    lcd.printf("Temp: %0.1f",temperature);
    
    for (int g = 6;g>0;g--) {
        
        lcd.locate(g+9,1);
        lcd.putc(127);
        HAL_Delay(200);
        lcd.putc(' ');
        
    }

    // ******* Oled 128 x 64 *******
    oled.setTextSize(2);
    oled.setTextCursor(0, 30);
    oled.printf("Temp: %0.1f\r", temperature);
    oled.display();

    for (int i = 0; i < 10; i++) {
      oled.setTextSize(2);
      oled.setTextCursor(col, 0);
      oled.putc(175);
      oled.display();
      col = col + 12;
      if (col > 118) {
        col = 0;
      }
      HAL_Delay(50);
    }
  }
}
