#include "PinNames.h"
#include "mbed.h"
#include "TextLCD.h"  // Important d'avoir la bonne librairie 
#include "DS18B20.h"

I2C i2c_pin(I2C_SDA, I2C_SCL);
DigitalOut myLed(PC_13);
TextLCD_I2C lcd(&i2c_pin, 0x4E);




DS18B20 sensor(PA_5); 
int col = 0;


// main() runs in its own thread in the OS
int main()
{
  // *********** Oled 128 x 64 *********
  

  // ******* LCD 1602 *************
  //lcd.locate(0, 0); //    Position initial
  lcd.setCursor(TextLCD::CurOff_BlkOff);
  lcd.cls();
  lcd.setBacklight(TextLCD::LightOn);
  lcd.printf("  Thermal sonde\n");

  while (true) {
    
    myLed = !myLed;
    float temperature = sensor.readTemp();
    // ***** LCD 1602 ***
    lcd.locate(0, 1);
    lcd.printf("Temp: %0.1f",temperature);
    
    for (int g = 6;g>0;g--) {
        
        lcd.locate(g+9,1);
        lcd.putc(127);
        HAL_Delay(200);
        lcd.putc(' ');
        
    }
    
    // ******* Oled 128 x 64 *******
    

    
      HAL_Delay(50);
    
  }
}