#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "DHT.h"

DHT dht(D4, DHT22);
LCD_DISCO_F746NG lcd;

int main() {
    
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    while(1){
        
        char humid[10];
        sprintf(humid, "%f", dht.ReadHumidity());
        
        char temp[10];
        sprintf(temp, "%f", dht.ReadTemperature(CELCIUS));
        
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Humidity: ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)humid, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"Temp: ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)temp, CENTER_MODE);

        
        }
    }
