#include "mbed.h"
#include <math.h>
#include <stdlib.h>
#include "PMW3901.h"

Serial pc(USBTX,USBRX);
InterruptIn mybutton(USER_BUTTON);
Ticker main_function; //interrupt

DigitalOut led1(LED1);
//SPI speed_sensor(PC_12,PC_11,PC_10);
SPI spi(PC_12,PC_11,PC_10);
//DigitalOut CS(PA_4);
DigitalOut cs(PA_4);

float dt = 0.01; // sec
float command = 0;
bool button_state = false;

/*void InitEncoder(void);*/

void init_SPI();

void start(void);
void grabData(void);
//void printData(void);
void initializeSensor(void);
void writeRegister(uint8_t addr, uint8_t data);
uint8_t readRegister(uint8_t addr);
void delayus(uint32_t us);

void step_command();

//void RX_ITR();
//void init_UART();

int main() {
    pc.baud(115200);
    init_SPI();
//    InitEncoder();      //don't care
    //InitMotor(PWM_FREQUENCY); // Set pwm period to 1ms.
    //init_UART();
    mybutton.fall(&step_command);
    initializeSensor();
    //main_function.attach_us(&position_control, dt*1000000);
    main_function.attach_us(&start, dt*1000000);

    while(1){}
}

void start(){
    cs = 0;
    grabData();
    //printData();
    cs = 1;
}

void init_SPI(){
    //CS.output = 1;
    cs = 1;
    //speed_sensor.format(8, 3);
    //speed_sensor.frequency(1000000);
    spi.format(8, 3);
    spi.frequency(1000000);
}

void step_command(){
    led1 = !led1;
    button_state = !button_state;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//=========================================================================
//Functions definitions
//=========================================================================

uint8_t readRegister(uint8_t addr) {
    wait_us(10);                                //tswr
    //LL_GPIO_ResetOutputPin(SPI3_CS2_GPIO_Port, SPI3_CS2_Pin);
    cs = 0;
    addr = addr & 0x7F;                         //Set MSB to 0 to indicate read operation

//    LL_SPI_TransmitData16(SPI3, addr);
//    while (!LL_SPI_IsActiveFlag_RXNE(SPI3)) {   //Stuck if not finished
//    }
//    LL_SPI_ReceiveData16(SPI3);                 //Just to clear RXNE
    spi.write(addr);
    
    wait_us(35);

//    LL_SPI_TransmitData16(SPI3, 0U);
//    while (!LL_SPI_IsActiveFlag_RXNE(SPI3)) {   //Stuck if not finished
//    }
//    uint8_t data_read = LL_SPI_ReceiveData16(SPI3);
    uint8_t data_read = spi.write(0U);
    
    wait_us(1);                             //tsclk-ncs
    //LL_GPIO_SetOutputPin(SPI3_CS2_GPIO_Port, SPI3_CS2_Pin);
    cs = 1;
    wait_us(20);                            //tsclk-ncs
    return data_read;                           //Returns 8-bit data from register
}

//=========================================================================
void writeRegister(uint8_t addr, uint8_t data) {
    //LL_GPIO_ResetOutputPin(SPI3_CS2_GPIO_Port, SPI3_CS2_Pin);
    cs = 0;
    addr = addr | 0x80;             //Set MSB to 1 to indicate write operation

//    LL_SPI_TransmitData16(SPI3, addr);
//    while (!LL_SPI_IsActiveFlag_RXNE(SPI3)) {   //Stuck if not finished
//    }
//    LL_SPI_ReceiveData16(SPI3);             //Just to clear RXNE
    spi.write(addr);

//    LL_SPI_TransmitData16(SPI3, data);
//    while (!LL_SPI_IsActiveFlag_RXNE(SPI3)) {   //Stuck if not finished
//    }
//    LL_SPI_ReceiveData16(SPI3);             //Just to clear RXNE
    spi.write(data);

    wait_us(25);                            //tsclk-ncs

    //LL_GPIO_SetOutputPin(SPI3_CS2_GPIO_Port, SPI3_CS2_Pin);
    cs = 1;
    wait_us(1);                             //tsclk-ncs
}

//=========================================================================
void initializeSensor(void) {
    writeRegister(0x7F, 0x00);
    writeRegister(0x55, 0x01);
    writeRegister(0x50, 0x07);
    writeRegister(0x7F, 0x0E);
    writeRegister(0x43, 0x10);

    if (readRegister(0x67) & 0x40)
        writeRegister(0x48, 0x04);
    else
        writeRegister(0x48, 0x02);

    writeRegister(0x7F, 0x00);
    writeRegister(0x51, 0x7B);
    writeRegister(0x50, 0x00);
    writeRegister(0x55, 0x00);
    writeRegister(0x7F, 0x0E);

    if (readRegister(0x73) == 0x00) {
        writeRegister(0x7F, 0x00);
        writeRegister(0x61, 0xAD);
        writeRegister(0x51, 0x70);
        writeRegister(0x7F, 0x0E);

        if (readRegister(0x70) <= 28)
            writeRegister(0x70, readRegister(0x70) + 14);
        else
            writeRegister(0x70, readRegister(0x70) + 11);

        writeRegister(0x71, readRegister(0x71) * 45 / 100);
    }

    writeRegister(0x7F, 0x00);
    writeRegister(0x61, 0xAD);
    writeRegister(0x7F, 0x03);
    writeRegister(0x40, 0x00);
    writeRegister(0x7F, 0x05);
    writeRegister(0x41, 0xB3);
    writeRegister(0x43, 0xF1);
    writeRegister(0x45, 0x14);
    writeRegister(0x5B, 0x32);
    writeRegister(0x5F, 0x34);
    writeRegister(0x7B, 0x08);
    writeRegister(0x7F, 0x06);
    writeRegister(0x44, 0x1B);
    writeRegister(0x40, 0xBF);
    writeRegister(0x4E, 0x3F);
    writeRegister(0x7F, 0x06);
    writeRegister(0x44, 0x1B);
    writeRegister(0x40, 0xBF);
    writeRegister(0x4E, 0x3F);
    writeRegister(0x7F, 0x08);
    writeRegister(0x65, 0x20);
    writeRegister(0x6A, 0x18);
    writeRegister(0x7F, 0x09);
    writeRegister(0x4F, 0xAF);
    writeRegister(0x5F, 0x40);
    writeRegister(0x48, 0x80);
    writeRegister(0x49, 0x80);
    writeRegister(0x57, 0x77);
    writeRegister(0x60, 0x78);
    writeRegister(0x61, 0x78);
    writeRegister(0x62, 0x08);
    writeRegister(0x63, 0x50);
    writeRegister(0x7F, 0x0A);
    writeRegister(0x45, 0x60);
    writeRegister(0x7F, 0x00);
    writeRegister(0x4D, 0x11);
    writeRegister(0x55, 0x80);
    writeRegister(0x74, 0x21);
    writeRegister(0x75, 0x1F);
    writeRegister(0x4A, 0x78);
    writeRegister(0x4B, 0x78);
    writeRegister(0x44, 0x08);
    writeRegister(0x45, 0x50);
    writeRegister(0x64, 0xFF);
    writeRegister(0x65, 0x1F);
    writeRegister(0x7F, 0x14);
    writeRegister(0x65, 0x67);
    writeRegister(0x66, 0x08);
    writeRegister(0x63, 0x70);
    writeRegister(0x7F, 0x15);
    writeRegister(0x48, 0x48);
    writeRegister(0x7F, 0x07);
    writeRegister(0x41, 0x0D);
    writeRegister(0x43, 0x14);
    writeRegister(0x4B, 0x0E);
    writeRegister(0x45, 0x0F);
    writeRegister(0x44, 0x42);
    writeRegister(0x4C, 0x80);
    writeRegister(0x7F, 0x10);
    writeRegister(0x5B, 0x02);
    writeRegister(0x7F, 0x07);
    writeRegister(0x40, 0x41);
    writeRegister(0x70, 0x00);

    wait_ms(10);

    writeRegister(0x32, 0x44);
    writeRegister(0x7F, 0x07);
    writeRegister(0x40, 0x40);
    writeRegister(0x7F, 0x06);
    writeRegister(0x62, 0xF0);
    writeRegister(0x63, 0x00);
    writeRegister(0x7F, 0x0D);
    writeRegister(0x48, 0xC0);
    writeRegister(0x6F, 0xD5);
    writeRegister(0x7F, 0x00);
    writeRegister(0x5B, 0xA0);
    writeRegister(0x4E, 0xA8);
    writeRegister(0x5A, 0x50);
    writeRegister(0x40, 0x80);

    wait_ms(250);

    writeRegister(0x7F, 0x14);
    writeRegister(0x6F, 0x1C);
    writeRegister(0x7F, 0x00);

}

//=========================================================================
void grabData(void) {
    static int totalX = 0;
    static int totalY = 0;
    uint8_t check = 0;
    if(button_state == true){
        check = readRegister(0x02) & 0x80;
        if (check) {
            deltaX_low = readRegister(0x03);        //Grabs data from the proper registers.
            deltaX_high = (readRegister(0x04) << 8) & 0xFF00; //Grabs data and shifts it to make space to be combined with lower bits.
            deltaY_low = readRegister(0x05);
            deltaY_high = (readRegister(0x06) << 8) & 0xFF00;
    
            deltaY = deltaX_high | deltaX_low;      //Combines the low and high bits.
            deltaX = deltaY_high | deltaY_low;
    //        pc.printf("deltaX: %d\t\t\tdeltaY: %d\n\r", deltaX, deltaY);    //Prints each individual count of deltaX and deltaY.
            //pc.printf("X-axis Counts: %d\t\tY-axis Counts: %d\n\r", totalX, totalY);  //Prints the total movement made during runtime.
            totalX += deltaX;
            totalY += deltaY;

        }

        printf("%d,%d\n\r", totalX, totalY);

    }
}