/*
 * PMW3901.h
 *
 *  Created on: 2020/7/22
 *      Author: open4416
 */

#ifndef INC_PMW3901_H_
#define INC_PMW3901_H_

#include <math.h>

//=========================================================================
//Variables and arrays used for communications and data storage
//=========================================================================
int8_t deltaX_low, deltaY_low;    	//Stores the low-bits of movement data.
int16_t deltaX_high, deltaY_high;   //Stores the high-bits of movement data.
int16_t deltaX, deltaY;             //Stores the combined value of low and high bits.

//=========================================================================
//Functions used to communicate with the sensor and grab/print data
//=========================================================================

void delayus(uint32_t us);


uint8_t readRegister(uint8_t addr);
//This function takes an 8-bit address in the form 0x00 and returns an 8-bit value in the form 0x00.

void writeRegister(uint8_t addr, uint8_t data);
//This function takes an 8-bit address and 8-bit data. Writes the given data to the given address.

void initializeSensor(void);
//Sets all of the registers needed for initialization and performance optimization.

void grabData(void);
//Grabs the deltaX and deltaY information from the proper registers and formats it into the proper format.
//
//void printData(void);
//Prints the data out to a serial terminal.

#endif
