/* Hello World! for the TextLCD Enhanced Library*/

#include "mbed.h"
#include "TextLCD.h"
#define apertado 0
#define solto 1

//#include "TextLCDScroll.h"

InterruptIn button1(D5);
InterruptIn button2(D4);

DigitalOut led(LED2);
 
// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx
 
// I2C Communication
I2C i2c_lcd(D14,D15); // SDA, SCL


TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD20x4);                  // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type

bool previous1=0, previous2=0;
int menu=0;

void aumenta_menu(){
    menu = menu + 1;
    if (menu>2){
        menu=2;
    }
}
    
void diminui_menu()
{
    menu = menu - 1;  
    if (menu<0){
        menu=0;
    }
}
    
    
int main() {   

    button1.rise(&aumenta_menu);
    button2.rise(&diminui_menu);
    
    lcd.setBacklight(TextLCD::LightOn);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
 
    while(1){
        
        while (menu==0){
            lcd.setAddress(0,0);
            lcd.printf("SELECIONE UMA FUNCAO ");
            lcd.setAddress(0,2);
            lcd.printf("1-SALVAR PONTOS");
            lcd.setAddress(0,3);
            lcd.printf("2-FUNCAO B");
        }
        lcd.cls();
        while (menu==1){
            lcd.setAddress(0,0);
            lcd.printf("SELECIONE O PONTO 1"); // Ponto 1
            lcd.setCursor(TextLCD::CurOff_BlkOff);
            lcd.setAddress(0,2);
            lcd.printf("1-SALVAR");
            lcd.setAddress(0,3);
            lcd.printf("2-CANCELAR OPERACAO");
            previous1 = 1;
            printf("dentro do menu1\r\n");
        }
        lcd.cls();
        while (menu==2){
            lcd.setAddress(0,0);
            lcd.printf("SELECIONE O PONTO 2"); // Ponto 2
            lcd.setCursor(TextLCD::CurOff_BlkOff);
            lcd.setAddress(0,2);
            lcd.printf("1-SALVAR");
            lcd.setAddress(0,3);
            lcd.printf("2-CANCELAR OPERACAO");
            previous1 = 1;
            printf("dentro do menu2\r\n");      
        }
        lcd.cls();
    }
}
            