#ifndef MBED_SDFILESYSTEM_GR_PEACH_H
#define MBED_SDFILESYSTEM_GR_PEACH_H

#include "SDFileSystem.h"

/**
 * A class to communicate a SD
 */
class SDFileSystem_GR_PEACH : public SDFileSystem {
public:

    /**
    * Constructor
    *
    * @param rootdir mount name
    */
    SDFileSystem_GR_PEACH(const char* name) : SDFileSystem(P8_5, P8_6, P8_3, P8_4, name), _sd_cd(P7_8), _connect(false) {
        // Set SPI clock rate to 20MHz for data transfer
        set_transfer_sck(20000000);
    }

    /**
    * Check if a SD is connected
    *
    * @return true if a SD is connected
    */
    bool connected() {
        if (_sd_cd.read() != 0) {
            _connect = false;
        }
        return _connect;
    }

    /**
     * Try to connect to a SD
     *
     * @return true if connection was successful
     */
    bool connect() {
        if (_sd_cd.read() == 0) {
            _connect = true;
        } else {
            _connect = false;
        }
        return _connect;
    }


private:
    DigitalIn   _sd_cd;
    bool        _connect;
};

#endif
