/*
    A featured example for beginners

    Control brightnesses of all 4 LEDs on the board using +/- keys for increment or decrement, 1/2/3/4 keys to select LED through your computer

    Eray Ozturk | erayozturk1@gmail.com
*/

#include "mbed.h"

// The mbed board can communicate with a host PC through a "USB Virtual Serial Port" over the same USB cable that is used for programming.
// If you use Windows, you need a driver. http://mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe
// With your mbed plugged in, and no explorer drive windows open, run the installer.
// The default baud rate is 9600
Serial pc(USBTX, USBRX); // tx, rx

Ticker flipper;
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

#define PWM_MAX 0.5

float brightness = 0.0;
float brigh_bckp;

int SelectedLED = 1;
int Selec_bckp;

void callback() {
    if (brightness>PWM_MAX) // limiter
        brightness = PWM_MAX;

    if (brightness<0.0)     // limiter
        brightness = 0.0;

    if (Selec_bckp!=SelectedLED || brigh_bckp!=brightness) {
        pc.printf("*Led%u : %5.1f%%\n",SelectedLED,brightness*100.0/PWM_MAX);
        Selec_bckp = SelectedLED;
        brigh_bckp = brightness;
    }
}

void SetBright() {
    switch (SelectedLED) {
        case 1:
            led1 = brightness;
            break;
        case 2:
            led2 = brightness;
            break;
        case 3:
            led3 = brightness;
            break;
        case 4:
            led4 = brightness;
            break;
        default:
            SelectedLED = 1;
    }
}

int main() {
    pc.printf("\n## Quad Brightness Controller ##\n");
    pc.printf("Press '+/-' to change selected LED's brightness\n");
    pc.printf("Use '1'-'4' keys to change selected LED\n");

    flipper.attach(&callback, 1.0); // call flip() in every 1 sec

    while (true) {
        if (pc.readable()) {
            char c = pc.getc();

            if ((c == '+') && (brightness < PWM_MAX)) {
                brightness += 0.01;
                SetBright();
            } else if ((c == '-') && (brightness > 0.0)) {
                brightness -= 0.01;
                SetBright();
            } else if (c == '1') {
                pc.printf("Led1 selected\n");
                SelectedLED = 1;
                brightness = 0.0;
            } else if (c == '2') {
                pc.printf("Led2 selected\n");
                SelectedLED = 2;
                brightness = 0.0;
            } else if (c == '3') {
                pc.printf("Led3 selected\n");
                SelectedLED = 3;
                brightness = 0.0;
            } else if (c == '4') {
                pc.printf("Led4 selected\n");
                SelectedLED = 4;
                brightness = 0.0;
            } else if (c == 'a') {
                pc.printf("Author: Eray Ozturk\n");
            }
        }
    }
}