#include "mbed.h"
#include <math.h>
#define MAXPOS 50  //Constante posicion maxima
 
PwmOut myServoX(PB_3); //Define salidas
PwmOut myServoY(PB_5);
PwmOut myServoZ(PB_4);
 
////////////////////////////////////////////////////////////////////////////////

int coord2us(float coord)               //funcion pasar coord X - Y a mm
{  
    if(0 <= coord <= MAXPOS)
    return int(750+coord*1900/50);// us
    return 750;
} 
 
//////////////////////////////////////////////////////////////////////////////// 

void vertex2d(float x, float y){ // Funcion para cambiar coord a ms
 
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    int pulseZ = coord2us(10);
    
    myServoX.pulsewidth_us(pulseX); //ms
    myServoY.pulsewidth_us(pulseY); //ms
    myServoZ.pulsewidth_us(pulseZ); //ms 
}

////////////////////////////////////////////////////////////////////////////////

void line(float x, float xf, float y, float yf){
    
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    int pulseZ = coord2us(10);
    myServoX.pulsewidth_us(pulseX); //ms
    myServoY.pulsewidth_us(pulseY); //ms
    myServoZ.pulsewidth_us(pulseZ); //ms 
    
    int pulseX = coord2us(xf);
    int pulseY = coord2us(yf);
    
    myServoX.pulsewidth_us(pulseX); //ms
    myServoY.pulsewidth_us(pulseY); //ms

    
    }


void linedat(){
    line (2,1,2,4);
    }

////////////////////////////////////////////////////////////////////////////////

void square(float x, float y, float l){
    
    }



void squaredat(){
    square (2,2,2)
    }

////////////////////////////////////////////////////////////////////////////////

void circlefun(int x, int y, int r){ //Funcion recibe coords para circulo y las pasa a ms

       int pulseX = coord2us(x); //Posicionar en el centro de la circunferencia
       int pulseY = coord2us(y);
       myServoX.pulsewidth_us(pulseX); //ms
       myServoY.pulsewidth_us(pulseY); //ms 
 
        
        
       for (int y = -r; y = r; y+=1) {
        int coorX = (r*r)-(y*y);
        //int coordX = sqrt(coorX);
        int coordX = pow(coorX,0.5);
        
        int pulseX = coord2us(coordX); //Paso coordenadas a ms
        int pulseY = coord2us(y);
        int pulseZ = coord2us(10);   
        
        
        myServoX.pulsewidth_us(pulseX); //ms
        myServoY.pulsewidth_us(pulseY); //ms  
        myServoZ.pulsewidth_us(pulseZ); //ms 
        }
    }
    
void circle()
{
    circlefun (0,0,1);
    
}

////////////////////////////////////////////////////////////////////////////////

void diag()
{
 vertex2d (0,0);
 vertex2d (10,10);
 vertex2d (20,20);
 vertex2d (30,30);
 wait(2);vertex2d(40,40);   
 wait(2);vertex2d(50,50);   
    } 
 
////////////////////////////////////////////////////////////////////////////////

void home() // Funcion para Home
{
vertex2d(0 ,0);
    }    
 
 
void maxpos() //  Funcion Maxima posicion
{
vertex2d(MAXPOS ,MAXPOS);
    }    
 

 
 
int main() {
     // configuracion de  periodo
    myServoX.period_ms(20);
    myServoY.period_ms(20);
    myServoZ.period_ms(20);
    
    while(1)
    {
     home();
     wait(3);
     circle();    
     wait(3);
     }
 

 
 
}
 
 
 