#include "mbed.h"
#include "FreescaleIAP.h"
 
// cantidad de bytes a guardar
const int CANT = 10;
 
DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
 
int main()
{
    unsigned int status_prg = 0;
    
    pc.baud(9600);
    
    // address es la dirección donde grabará los 10 bytes
    // el último sector de FLASH
    const int address = flash_size() - SECTOR_SIZE;   
    
    pc.printf("direccion donde graba: %x\r\ncantidad de bytes maximo %d\r\n", address, SECTOR_SIZE);
    
    // data apunta al inicio de la dirección donde están grabados loos datos
    char *data = (char*)address;    

//    erase_sector(address);  // pone todo el sector de datos en 0xFF (borrado)

    // buffer donde cargo datos que leo o que voy a escribir
    char valores[CANT];

    pc.printf("- contenido actual: ---\r\n");
    // muestra el contenido de los 10 bytes
    // carga datos en el vector 
    // si es 0xFF (nunca se utilizó) coloca en el vector un valor default 
    for(int k =0; k < CANT; k++) {                
        if (*(data + k) != 0xFF) 
            valores[k] = *(data + k);
        else 
            valores[k] = k;
        pc.printf("%x - %d\r\n", valores[k], valores[k]);
    }
 
    pc.printf("- a grabar: ---\r\n");
    
          
    bool grabado = false;
    while(true) {
        // si se recibe 'g' de la pc...
        if (pc.getc() == 'g'){
            
            // y no se grabó aun...
            if (!grabado){
                // le suma 20 a cada valor en el vector 
                for(int k =0; k < CANT; k++) {
                   valores[k] = valores[k] + 20;                   
                   pc.printf("%x - %d\r\n", valores[k], valores[k]);
                }
                
                // borra el espacio de FLASH
                status_prg = erase_sector(address);
                pc.printf("borrado 0x%02X-----\r\n", status_prg);
                
                // guarda el vector en FLASH
                status_prg = program_flash(address, (char*)&valores, CANT);
                pc.printf("grabado 0x%02X-----\r\n", status_prg);
                grabado = true;
            }
        }
    }
}