#include "mbed.h"

/*
* Ejemplo 01.eb - Máquinas de estados
*
* LED rojo 0.1s encendido y 1.9s apagado
* Con máquinas de estados.
*
*/

// constantes para configurar Ticker 
#define     TICK_MS         10

// constantes para tiempo on y tiempo off (En ms)
#define     LED_T_ON_MS     100
#define     LED_T_OFF_MS    1900

#define     TO_LED_OFF_MS  LED_T_OFF_MS / TICK_MS
#define     TO_LED_ON_MS   LED_T_ON_MS / TICK_MS

// Defines para GPIO en S08
/*
#define     LED     PTAD_PTAD0
#define     _LED     PTADD_PTADD0
*/

// Define estado para apagado y encendido
// (El RGB on-board de FRDM es AC => encendido si LO)
#define     APAGADO     1
#define     ENCENDIDO   0

// Estados de la máquina de estados
enum { 
    LED_OFF, 
    LED_ON
};

// 
Ticker tick;

// Declara LED como DigitalOut correspondiente a LED Rojo
DigitalOut LED(LED_RED);

//Serial serusb(USBTX, USBRX);

// variable para time out encendido y apagado
unsigned int LED_tout = 0;

// Variable de estado
char LED_estado = LED_OFF;

// Máquina de estados
void LED_Step();
void LED_Tick();

// inicialización del HW
void init_mcu();

int main()
{
    init_mcu();

    for(;;) {
        LED_Step();
        
    }
}

// Máquina de estados
void LED_Step(){
    //serusb.printf("%d", LED_tout);
    if (LED_tout > 0)      // Si no pasó el tiempo...
        return;            // ...sale de ME
    
    switch(LED_estado){
        default:  // si estado no definido => LED_OFF
        case LED_OFF:                   // estado   LED_OFF
            LED = APAGADO;              // salidas: Apaga LED
            LED_estado = LED_ON;        // próximo estado
            LED_tout = TO_LED_OFF_MS;   // timeout <- timeout ON
            break;
            
        case LED_ON:                    // estado    LED_ON 
            LED = ENCENDIDO;            // salidas: Enciende LED
            LED_estado = LED_OFF;       // próximo estado
            LED_tout = TO_LED_ON_MS;   // timeout <- timeout OFF           
            break;
    }
}

// Para actualizar timeout de ME_LED
void LED_Tick() {
    if (LED_tout > 0) 
        LED_tout--;
}

// ISR de TPM1 Overflow para MCU S08
/*
__interrupt VectorNumber_tpm1ovf tpm_overflow(){
    TPM1SC_TOF = 0;
    
    LED_tick();
}
*/

void init_mcu(){
  // ticker: ejecuta LED_Tick cada TICK_MS ms
  tick.attach(&LED_Tick, TICK_MS / 1000.0);
 
  LED = APAGADO;

  // Inicialización de GPIO y TPM1 para S08
  /*  
    LED = 0;
    _LED = 1;
    
    TPM1SC = 0b01001011; // ftpm = 1us
    TPM1MOD = 9999; // overflow cada 1ms
   */
}