#include "mbed.h"
#include "Pulse.h"              //Libreria PulseIn                        
Serial bt(PA_9,PA_10);         //Comunicacion con el modulo HC-06                 
DigitalIn signal(PC_7);        //Señal del sensor de obstaculo         
DigitalOut lamp(PB_3);        //Lampara
DigitalOut s0(PB_6);                
DigitalOut s1(PA_7);                    //Pines para el Sensor de color TCS230
DigitalOut s2(PA_6);
DigitalOut s3(PA_5); 
DigitalOut pinMotorA(PC_10);                 //Declaracion de pins del motor reductor
DigitalOut pinMotorB(PC_12);                   
PulseInOut sensorSalida(PB_9);          //Salida del Sensor de color

int main(){
    bt.baud(9600);
    int conteo=0;
    int Rojo = 0;
    int Verde = 0;                    
    int Azul = 0;
    pinMotorA=0;                    //motor prendido al inicio
    pinMotorB=1;
    lamp=0;
    s0=1;                          //20% Freq del sensor
    s1=0;
    
    for(;;){
    //Sensor de Color
    s2=0;                                   //ROJO
    s3=0;
    wait(.1);
    Rojo = sensorSalida.read_low_us();
    wait(.1);
    
    s2=1;                                   //Verde
    s3=1;
    wait(.1);
    Verde = sensorSalida.read_low_us();
    wait(.1);
    
    s2=0;                                   //Azul
    s3=1;
    wait(.1);
    Azul = sensorSalida.read_low_us();
    wait(.1);
    
    if (Rojo < 35 && Verde > 100 && Azul < 82)  bt.printf(" . *** ROJO ***");
    if (Rojo > 105 && Verde > 110 && Azul >83 ) bt.printf(" . *** NEGRO ***");
    if (Rojo > 20 && Verde < 28 && Azul < 27)   bt.printf(" . *** VERDE ***");
    //Sensor de Objetos 
    float valor = signal.read();  
     valor = signal.read();
    if(valor==0){
        conteo++; 
        while(signal.read()==0){                           //  while Para evitar que siga tomando valores (antirebote de señal)
            wait(.1); 
            
            }  
            bt.printf("%d",conteo);
             }
        
    
    if(conteo>=10){
        bt.printf("*El proceso de conteo ha terminado*");
        lamp=1;
        wait(4.5);
        pinMotorA=0;                    //motor apagado y el rele se activa la lampara prendida al terminar el proceso
        pinMotorB=0;
        conteo=0;
        }else if(conteo==0){
            lamp=0;
            pinMotorA=0;                    //motor prendido 
            pinMotorB=1;
            }
    
    }
    
    }