#include "mbed.h"
#include "TextLCD.h"
InterruptIn P1(PA_0);
InterruptIn P2(PA_4);
InterruptIn P3(PA_5);
DigitalOut L1(PD_12);
DigitalOut L2(PD_13);
DigitalOut L3(PD_14);
DigitalOut L4(PD_15);
Serial pc(PA_2,PA_3);
I2C i2c_lcd(PB_7, PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);

////////ENTRADAS ANALOGICAS
AnalogIn IFASE1(PB_0);
AnalogIn IFASE2(PB_1);
AnalogIn IFASE3(PC_5);
AnalogIn VFASE1_2(PC_0);
AnalogIn VFASE2_3(PA_7);
AnalogIn VFASE3_1(PC_4);
float valor_IFASE1=0;
float valor_IFASE2=0;
float valor_IFASE3=0;
float valor_VFASE1_2=0;
float valor_VFASE2_3=0;
float valor_VFASE3_1=0;
bool vP1=0;
bool vP2=0;
bool vP3=0;
bool vP4=0;
////ESTRUCTURA

void pantcurr(void)
{
    L1.write(1);
    L2.write(0);
    L3.write(0);
    L4.write(0);
}

void pantvolt(void)
{
    L1.write(0);
    L2.write(1);
    L3.write(0);
    L4.write(0);
}

void pantpow(void)
{
    L1.write(0);
    L2.write(0);
    L3.write(1);
    L4.write(0);
}
void pantprinc(void)
{
    L1.write(0);
    L2.write(0);
    L3.write(0);
    L4.write(1);
}


int main()
{
        P1.rise(&pantcurr);
        P2.rise(&pantvolt);
        P3.rise(&pantpow);
        P1.fall(&pantprinc);
        while(true) {
        pc.baud(115200);
        valor_IFASE1=IFASE1.read();
        valor_IFASE2=IFASE2.read();
        valor_IFASE3=IFASE3.read();
        valor_VFASE1_2=VFASE1_2.read();
        valor_VFASE2_3=VFASE2_3.read();
        valor_VFASE3_1=VFASE3_1.read();
        vP1=L1.read();
        vP2=L2.read();
        vP3=L3.read();
        vP4=L4.read();
        lcd.setBacklight(TextLCD::LightOn);
        lcd.setCursor(TextLCD::CurOff_BlkOff);
        if(vP1==1) {
            lcd.cls();
            const char* text = "CORRIENTES DE FASE";
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf(text);
            lcd.locate(0,2);
            lcd.printf("IA%2.1f%", valor_IFASE1*20);
            lcd.locate(7,2);
            lcd.printf("IB%2.1f%", valor_IFASE2*20);
            lcd.locate(14,2);
            lcd.printf("IC%2.1f%", valor_IFASE3*20);
            wait(0.5);
        }
        if(vP2==1) {
            lcd.cls();
            const char* text = "VOLTAJES LINEA LINEA";
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf(text);
            lcd.locate(0,2);
            lcd.printf("V1=%1.0f%", valor_VFASE1_2*480);
            lcd.locate(7,2);
            lcd.printf("V2=%1.0f%", valor_VFASE2_3*480);
            lcd.locate(14,2);
            lcd.printf("V3=%1.0f%", valor_VFASE3_1*480);
            L2.write(1);
            wait(0.5);
        }
        if(vP3==1) {
            lcd.cls();
            const char* text = "POTENCIAS POR FASE";
            lcd.cls();
            lcd.locate(1,0);
            lcd.printf(text);
            lcd.locate(0,2);
            lcd.printf("P1=%1.1f%", (((valor_IFASE1*20)*(valor_VFASE1_2*480)))/1000);
            lcd.locate(7,2);
            lcd.printf("P2=%1.1f%", (((valor_IFASE2*20)*(valor_VFASE2_3*480)))/1000);
            lcd.locate(14,2);
            lcd.printf("P3=%1.1f%", (((valor_IFASE3*20)*(valor_VFASE3_1*480)))/1000);
            wait(0.5);
        }
        if(vP4==1) {
            const char* text = "PROYECTO FINAL";
            const char* text1 = "MAESTRIA ELECTRONICA";
            const char* text2 = "DAVID BALDEON";
            lcd.cls();
            lcd.locate(3,0);
            lcd.printf(text);
            lcd.locate(0,2);
            lcd.printf(text1);
            lcd.locate(4,3);
            lcd.printf(text2);
            wait(0.5);
        }
        

    }
}



